/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;

public class DomJavaUtil {
    private DomJavaUtil() {
    }

    public static PsiClass findClass(String name, PsiFile file, Module module, GlobalSearchScope searchScope) {
        GlobalSearchScope scope;
        if (name == null) {
            return null;
        }
        if (name.indexOf(36) >= 0) {
            name = name.replace('$', '.');
        }
        if (searchScope == null) {
            if (module != null) {
                VirtualFile virtualFile = (file = file.getOriginalFile()).getVirtualFile();
                if (virtualFile == null) {
                    scope = GlobalSearchScope.moduleRuntimeScope(module, true);
                } else {
                    ProjectFileIndex fileIndex = ProjectRootManager.getInstance(file.getProject()).getFileIndex();
                    boolean tests = fileIndex.isInTestSourceContent(virtualFile);
                    scope = module.getModuleRuntimeScope(tests);
                }
            } else {
                scope = file.getResolveScope();
            }
        } else {
            scope = searchScope;
        }
        PsiClass aClass = JavaPsiFacade.getInstance(file.getProject()).findClass(name, scope);
        if (aClass != null) assert (aClass.isValid()) : name;
        return aClass;
    }

    public static PsiClass findClass(String name, DomElement element) {
        assert (element.isValid());
        if (DomUtil.hasXml(element)) {
            return DomJavaUtil.findClass(name, DomUtil.getFile(element), element.getModule(), element.getResolveScope());
        }
        return null;
    }
}

