/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.EvaluatedXmlNameImpl;
import com.intellij.util.xml.XmlName;
import org.jetbrains.annotations.NonNls;

public class DummyEvaluatedXmlName
implements EvaluatedXmlName {
    private final XmlName myXmlName;
    private final String myNamespace;

    public DummyEvaluatedXmlName(String localName, String namespace) {
        this(new XmlName(localName), namespace);
    }

    public DummyEvaluatedXmlName(XmlName xmlName, String namespace) {
        this.myXmlName = xmlName;
        this.myNamespace = namespace;
    }

    @Override
    public XmlName getXmlName() {
        return this.myXmlName;
    }

    @Override
    public EvaluatedXmlName evaluateChildName(XmlName name) {
        String namespaceKey = name.getNamespaceKey();
        if (namespaceKey == null) {
            return new DummyEvaluatedXmlName(name.getLocalName(), this.myNamespace);
        }
        return EvaluatedXmlNameImpl.createEvaluatedXmlName(name, namespaceKey, false);
    }

    @Override
    public boolean isNamespaceAllowed(String namespace, XmlFile file, boolean qualified) {
        return namespace.equals(this.myNamespace);
    }

    @Override
    @NonNls
    public String getNamespace(XmlElement parentElement, XmlFile file) {
        return this.myNamespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DummyEvaluatedXmlName that = (DummyEvaluatedXmlName)o;
        if (this.myNamespace != null ? !this.myNamespace.equals(that.myNamespace) : that.myNamespace != null) {
            return false;
        }
        return !(this.myXmlName != null ? !this.myXmlName.equals(that.myXmlName) : that.myXmlName != null);
    }

    public int hashCode() {
        int result = this.myXmlName != null ? this.myXmlName.hashCode() : 0;
        result = 31 * result + (this.myNamespace != null ? this.myNamespace.hashCode() : 0);
        return result;
    }
}

