/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NonNls;

public class XmlName
implements Comparable<XmlName> {
    private final String myLocalName;
    private final String myNamespaceKey;
    private final int myHashCode;

    public XmlName(@NonNls String localName) {
        this(localName, null);
    }

    public XmlName(@NonNls String localName, String namespaceKey) {
        this.myLocalName = localName;
        this.myNamespaceKey = namespaceKey;
        this.myHashCode = 31 * this.myLocalName.hashCode() + (this.myNamespaceKey != null ? this.myNamespaceKey.hashCode() : 0);
    }

    public final String getLocalName() {
        return this.myLocalName;
    }

    public final String getNamespaceKey() {
        return this.myNamespaceKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlName xmlName = (XmlName)o;
        if (!this.myLocalName.equals(xmlName.myLocalName)) {
            return false;
        }
        if (Comparing.equal((String)this.myNamespaceKey, (String)xmlName.myNamespaceKey)) {
            return true;
        }
        return !(this.myNamespaceKey != null ? !this.myNamespaceKey.equals(xmlName.myNamespaceKey) : xmlName.myNamespaceKey != null);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    @Override
    public int compareTo(XmlName o) {
        int i = this.myLocalName.compareTo(o.myLocalName);
        if (i != 0) {
            return i;
        }
        return Comparing.compare((Comparable)((Object)this.myNamespaceKey), (Comparable)((Object)o.myNamespaceKey));
    }

    public String toString() {
        return this.myNamespaceKey + " : " + this.myLocalName;
    }
}

