/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.actions;

import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.actions.generate.DomTemplateRunner;
import com.intellij.util.xml.ui.actions.generate.CreateDomElementAction;
import java.util.Map;

public abstract class CreateClassMappingAction<T extends DomElement>
extends CreateDomElementAction<T> {
    private final String myBaseClass;
    private final String myTemplate;

    public CreateClassMappingAction(Class<T> contextClass, String baseClass, String template) {
        super(contextClass);
        this.myBaseClass = baseClass;
        this.myTemplate = template;
    }

    @Override
    protected DomElement createElement(T context, Editor editor, PsiFile file, Project project) {
        PsiClass selectedClass;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            PsiClass baseClass = this.getBaseClass(context, project, this.myBaseClass);
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance(project).createInheritanceClassChooser(this.getChooserTitle(), GlobalSearchScope.allScope(project), baseClass, null, new ClassFilter(){

                @Override
                public boolean isAccepted(PsiClass aClass) {
                    return !aClass.isInterface() && !aClass.hasModifierProperty("abstract");
                }
            });
            chooser.showDialog();
            selectedClass = chooser.getSelected();
        } else {
            selectedClass = this.getBaseClass(context, project, this.myBaseClass == null ? "java.lang.Object" : this.myBaseClass);
        }
        if (selectedClass == null) {
            return null;
        }
        return this.createElement(context, editor, file, project, selectedClass);
    }

    protected DomElement createElement(T context, Editor editor, PsiFile file, final Project project, PsiClass selectedClass) {
        HashMap map = new HashMap();
        map.put("CLASS_NAME", selectedClass.getQualifiedName());
        new WriteCommandAction.Simple(project, new PsiFile[]{file}, (DomElement)context, editor, (Map)map){
            final /* synthetic */ DomElement val$context;
            final /* synthetic */ Editor val$editor;
            final /* synthetic */ Map val$map;
            {
                this.val$context = domElement;
                this.val$editor = editor;
                this.val$map = map;
                super(x0, x1);
            }

            @Override
            protected void run() throws Throwable {
                DomTemplateRunner.getInstance(project).runTemplate(CreateClassMappingAction.this.createElement(this.val$context), CreateClassMappingAction.this.myTemplate, this.val$editor, this.val$map);
            }
        }.execute();
        return null;
    }

    protected String getChooserTitle() {
        String text = this.getTemplatePresentation().getText();
        if (text.endsWith("...")) {
            text = StringUtil.trimEnd((String)text, (String)"...");
        }
        return "Choose " + text + " Class";
    }

    protected abstract DomElement createElement(T var1);

    protected PsiClass getBaseClass(T context, Project project, String baseClass) {
        return baseClass == null ? null : JavaPsiFacade.getInstance(project).findClass(baseClass, GlobalSearchScope.allScope(project));
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }
}

