/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters.values;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NonNls;

public abstract class ClassValueConverter
extends Converter<PsiClass>
implements CustomReferenceConverter {
    public static ClassValueConverter getClassValueConverter() {
        return ServiceManager.getService(ClassValueConverter.class);
    }

    @Override
    public PsiClass fromString(@NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        Module module = context.getModule();
        XmlFile psiFile = context.getFile();
        Project project = psiFile.getProject();
        return DomJavaUtil.findClass(s, context.getFile(), context.getModule(), ClassValueConverter.getScope(project, module, psiFile));
    }

    @Override
    public String toString(PsiClass psiClass, ConvertContext context) {
        return psiClass == null ? null : psiClass.getQualifiedName();
    }

    public abstract PsiReference[] createReferences(GenericDomValue var1, PsiElement var2, ConvertContext var3);

    public static GlobalSearchScope getScope(Project project, Module module, PsiFile psiFile) {
        if (module == null || psiFile == null) {
            return ProjectScope.getAllScope(project);
        }
        VirtualFile file = psiFile.getOriginalFile().getVirtualFile();
        if (file == null) {
            return ProjectScope.getAllScope(project);
        }
        boolean inTests = ProjectRootManager.getInstance(project).getFileIndex().isInTestSourceContent(file);
        return module.getModuleRuntimeScope(inTests);
    }
}

