/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters.values;

import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomBundle;
import com.intellij.util.xml.ResolvingConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;

public class NumberValueConverter
extends ResolvingConverter<String> {
    private final Class myNumberClass;
    private final boolean myAllowEmpty;

    public NumberValueConverter(Class numberClass, boolean allowEmpty) {
        this.myNumberClass = numberClass;
        this.myAllowEmpty = allowEmpty;
    }

    @Override
    public String fromString(@NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        if (this.myAllowEmpty && s.trim().length() == 0) {
            return s;
        }
        return NumberValueConverter.parseNumber(s, this.myNumberClass) == null ? null : s;
    }

    @Override
    public String toString(String s, ConvertContext context) {
        return null;
    }

    @Override
    public String getErrorMessage(String s, ConvertContext context) {
        if (s == null) {
            return super.getErrorMessage(s, context);
        }
        return s.trim().length() == 0 ? DomBundle.message("value.converter.format.exception.empty.string", this.myNumberClass.getName()) : DomBundle.message("value.converter.format.exception", s, this.myNumberClass.getName());
    }

    @Override
    public Collection<? extends String> getVariants(ConvertContext context) {
        return Collections.emptySet();
    }

    public static Number parseNumber(String text, Class targetClass) {
        try {
            String trimmed = text.trim();
            if (targetClass.equals(Byte.class) || targetClass.equals(Byte.TYPE)) {
                return Byte.decode(trimmed);
            }
            if (targetClass.equals(Short.class) || targetClass.equals(Short.TYPE)) {
                return Short.decode(trimmed);
            }
            if (targetClass.equals(Integer.class) || targetClass.equals(Integer.TYPE)) {
                return Integer.decode(trimmed);
            }
            if (targetClass.equals(Long.class) || targetClass.equals(Long.TYPE)) {
                return Long.decode(trimmed);
            }
            if (targetClass.equals(BigInteger.class)) {
                return NumberValueConverter.decodeBigInteger(trimmed);
            }
            if (targetClass.equals(Float.class) || targetClass.equals(Float.TYPE)) {
                return Float.valueOf(trimmed);
            }
            if (targetClass.equals(Double.class) || targetClass.equals(Double.TYPE)) {
                return Double.valueOf(trimmed);
            }
            if (targetClass.equals(BigDecimal.class) || targetClass.equals(Number.class)) {
                return new BigDecimal(trimmed);
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return null;
    }

    private static BigInteger decodeBigInteger(String value) {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (value.startsWith("0x", index) || value.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (value.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (value.startsWith("0", index) && value.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        BigInteger result = new BigInteger(value.substring(index), radix);
        return negative ? result.negate() : result;
    }
}

