/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomBundle;
import com.intellij.util.xml.DomElement;

public class AddDomElementQuickFix<T extends DomElement>
implements LocalQuickFix {
    protected final T myElement;
    protected final String myName;

    public AddDomElementQuickFix(T element) {
        this.myElement = element.createStableCopy();
        this.myName = this.computeName();
    }

    @Override
    public String getName() {
        return this.myName;
    }

    private String computeName() {
        String name = this.myElement.getXmlElementName();
        return this.isTag() ? DomBundle.message("add.element.fix.name", name) : DomBundle.message("add.attribute.fix.name", name);
    }

    private boolean isTag() {
        return this.myElement.getXmlElement() instanceof XmlTag;
    }

    @Override
    public String getFamilyName() {
        return DomBundle.message("quick.fixes.family", new Object[0]);
    }

    @Override
    public void applyFix(Project project, ProblemDescriptor descriptor) {
        this.myElement.ensureXmlElementExists();
    }
}

