/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.model.DomModel;
import com.intellij.util.xml.model.MultipleDomModelFactory;
import com.intellij.util.xml.model.SimpleModelFactory;
import com.intellij.util.xml.model.impl.CachedMultipleDomModelFactory;
import com.intellij.util.xml.model.impl.CachedSimpleDomModelFactory;
import com.intellij.util.xml.model.impl.DomModelFactoryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public abstract class BaseDomModelFactory<S extends UserDataHolder, T extends DomElement, M extends DomModel<T>, C extends PsiElement>
extends DomModelFactoryHelper<T>
implements SimpleModelFactory<T, M>,
MultipleDomModelFactory<S, T, M> {
    private final Project myProject;
    private final SimpleModelFactory<T, M> mySimpleDomModelFactory;
    private final MultipleDomModelFactory<S, T, M> myMultipleDomModelFactory;

    protected BaseDomModelFactory(Class<T> aClass, Project project, @NonNls String name) {
        super(aClass, DomService.getInstance().createModelMerger());
        this.myProject = project;
        this.mySimpleDomModelFactory = this.createSimpleModelFactory(aClass, this.getModelMerger(), project, name);
        this.myMultipleDomModelFactory = this.createMultipleDomModelFactory(aClass, this.getModelMerger(), project, name);
    }

    protected abstract S getModelScope(XmlFile var1);

    protected abstract List<M> computeAllModels(S var1);

    protected abstract M createCombinedModel(Set<XmlFile> var1, DomFileElement<T> var2, M var3, S var4);

    public M getModel(C context) {
        PsiFile psiFile = context.getContainingFile();
        if (psiFile instanceof XmlFile) {
            return this.getModelByConfigFile((XmlFile)psiFile);
        }
        return null;
    }

    @Override
    public List<M> getAllModels(S scope) {
        return this.myMultipleDomModelFactory.getAllModels(scope);
    }

    @Override
    public M getModelByConfigFile(XmlFile psiFile) {
        return this.mySimpleDomModelFactory.getModelByConfigFile(psiFile);
    }

    public Object[] computeDependencies(M model, S scope) {
        ArrayList<Object> dependencies = new ArrayList<Object>();
        dependencies.add(PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        if (scope != null) {
            dependencies.add(ProjectRootManager.getInstance(this.getProject()));
        }
        return ArrayUtil.toObjectArray(dependencies);
    }

    protected M computeModel(XmlFile psiFile, S scope) {
        if (scope == null) {
            return null;
        }
        List<M> models = this.getAllModels(scope);
        for (DomModel model : models) {
            Set<XmlFile> configFiles = model.getConfigFiles();
            if (!configFiles.contains(psiFile)) continue;
            return (M)model;
        }
        return null;
    }

    @Override
    public M getCombinedModel(S scope) {
        return this.myMultipleDomModelFactory.getCombinedModel(scope);
    }

    @Override
    public Set<XmlFile> getAllConfigFiles(S scope) {
        return this.myMultipleDomModelFactory.getAllConfigFiles(scope);
    }

    @Override
    public DomFileElement<T> createMergedModelRoot(Set<XmlFile> configFiles) {
        return this.mySimpleDomModelFactory.createMergedModelRoot(configFiles);
    }

    private CachedMultipleDomModelFactory<S, T, M, C> createMultipleDomModelFactory(Class<T> aClass, ModelMerger modelMerger, Project project, String name) {
        return new CachedMultipleDomModelFactory<S, T, M, C>(aClass, modelMerger, project, name){

            @Override
            public M getModel(C context) {
                return BaseDomModelFactory.this.getModel(context);
            }

            @Override
            protected List<M> computeAllModels(S scope) {
                return BaseDomModelFactory.this.computeAllModels(scope);
            }

            @Override
            protected M createCombinedModel(Set<XmlFile> configFiles, DomFileElement<T> mergedModel, M firstModel, S scope) {
                return BaseDomModelFactory.this.createCombinedModel(configFiles, mergedModel, firstModel, scope);
            }

            @Override
            public Object[] computeDependencies(M model, S scope) {
                return BaseDomModelFactory.this.computeDependencies(model, scope);
            }

            @Override
            public S getModelScope(XmlFile xmlFile) {
                return BaseDomModelFactory.this.getModelScope(xmlFile);
            }
        };
    }

    private CachedSimpleDomModelFactory<T, M, S> createSimpleModelFactory(Class<T> aClass, ModelMerger modelMerger, Project project, String name) {
        return new CachedSimpleDomModelFactory<T, M, S>(aClass, modelMerger, project, name){

            @Override
            protected M computeModel(XmlFile psiFile, S scope) {
                return BaseDomModelFactory.this.computeModel(psiFile, scope);
            }

            @Override
            public Object[] computeDependencies(M model, S scope) {
                return BaseDomModelFactory.this.computeDependencies(model, scope);
            }

            @Override
            public S getModelScope(XmlFile file) {
                return BaseDomModelFactory.this.getModelScope(file);
            }
        };
    }

    public Project getProject() {
        return this.myProject;
    }
}

