/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.model.DomModel;
import com.intellij.util.xml.model.DomModelCache;
import com.intellij.util.xml.model.impl.CachedDomModelFactory;
import com.intellij.util.xml.model.impl.SimpleDomModelFactory;
import org.jetbrains.annotations.NonNls;

public abstract class CachedSimpleDomModelFactory<T extends DomElement, M extends DomModel<T>, Scope extends UserDataHolder>
extends SimpleDomModelFactory<T, M>
implements CachedDomModelFactory<T, M, Scope> {
    private final DomModelCache<M, XmlFile> myModelCache;

    protected CachedSimpleDomModelFactory(Class<T> aClass, ModelMerger modelMerger, Project project, @NonNls String name) {
        super(aClass, modelMerger);
        this.myModelCache = new DomModelCache<M, XmlFile>(project, name + " model"){

            @Override
            protected CachedValueProvider.Result<M> computeValue(XmlFile file) {
                file = (XmlFile)file.getOriginalFile();
                Object scope = CachedSimpleDomModelFactory.this.getModelScope(file);
                Object model = CachedSimpleDomModelFactory.this.computeModel(file, scope);
                return new CachedValueProvider.Result(model, CachedSimpleDomModelFactory.this.computeDependencies(model, scope));
            }
        };
    }

    @Override
    public M getModelByConfigFile(XmlFile psiFile) {
        if (psiFile == null) {
            return null;
        }
        return (M)((DomModel)this.myModelCache.getCachedValue(psiFile));
    }

    protected abstract M computeModel(XmlFile var1, Scope var2);
}

