/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.tree;

import com.intellij.openapi.util.Key;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.swing.Icon;

public abstract class AbstractDomElementNode
extends SimpleNode {
    public static final Key<Map<Class, Boolean>> TREE_NODES_HIDERS_KEY = Key.create((String)"TREE_NODES_HIDERS_KEY");
    private static final Comparator<Class> INHERITORS_COMPARATOR = new Comparator<Class>(){

        @Override
        public int compare(Class o1, Class o2) {
            return o1.isAssignableFrom(o2) ? 1 : -1;
        }
    };
    private boolean isExpanded;

    protected AbstractDomElementNode(DomElement element) {
        this(element, null);
    }

    @Override
    public String toString() {
        return this.getNodeName();
    }

    protected AbstractDomElementNode(DomElement element, SimpleNode parent) {
        super(element.getManager().getProject(), parent);
    }

    public abstract DomElement getDomElement();

    public abstract String getNodeName();

    public abstract String getTagName();

    public Icon getNodeIcon() {
        return this.getDomElement().getPresentation().getIcon();
    }

    protected String getPropertyName() {
        return this.getDomElement().getPresentation().getTypeName();
    }

    protected boolean shouldBeShown(Type type) {
        Map hiders = (Map)DomUtil.getFile(this.getDomElement()).getUserData(TREE_NODES_HIDERS_KEY);
        if (type == null || hiders == null || hiders.size() == 0) {
            return true;
        }
        Class aClass = ReflectionUtil.getRawType((Type)type);
        ArrayList allParents = new ArrayList();
        for (Map.Entry entry : hiders.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(aClass)) continue;
            allParents.add(entry.getKey());
        }
        if (allParents.size() == 0) {
            return false;
        }
        Collections.sort(allParents, INHERITORS_COMPARATOR);
        return (Boolean)hiders.get(allParents.get(0));
    }

    protected SimpleTextAttributes getSimpleAttributes(@SimpleTextAttributes.StyleAttributeConstant int style) {
        return new SimpleTextAttributes(style, SimpleTextAttributes.REGULAR_ATTRIBUTES.getFgColor());
    }

    protected SimpleTextAttributes getWavedAttributes(@SimpleTextAttributes.StyleAttributeConstant int style) {
        return new SimpleTextAttributes(style | 8, SimpleTextAttributes.REGULAR_ATTRIBUTES.getFgColor(), SimpleTextAttributes.ERROR_ATTRIBUTES.getFgColor());
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
    }
}

