/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.ui.DomUIFactory;
import com.intellij.util.xml.ui.DomWrapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;

public class DomCollectionWrapper<T>
extends DomWrapper<T> {
    private final DomElement myDomElement;
    private final DomCollectionChildDescription myChildDescription;
    private final Method mySetter;
    private final Method myGetter;

    public DomCollectionWrapper(DomElement domElement, DomCollectionChildDescription childDescription) {
        this(domElement, childDescription, DomUIFactory.findMethod(ReflectionUtil.getRawType((Type)childDescription.getType()), "setValue"), DomUIFactory.findMethod(ReflectionUtil.getRawType((Type)childDescription.getType()), "getValue"));
    }

    public DomCollectionWrapper(DomElement domElement, DomCollectionChildDescription childDescription, Method setter, Method getter) {
        this.myDomElement = domElement;
        this.myChildDescription = childDescription;
        this.mySetter = setter;
        this.myGetter = getter;
    }

    @Override
    public DomElement getExistingDomElement() {
        return this.myDomElement;
    }

    @Override
    public DomElement getWrappedElement() {
        List<? extends DomElement> list = this.myChildDescription.getValues(this.myDomElement);
        return list.isEmpty() ? null : list.get(0);
    }

    @Override
    public void setValue(T value) throws IllegalAccessException, InvocationTargetException {
        List<? extends DomElement> list = this.myChildDescription.getValues(this.myDomElement);
        DomElement domElement = list.isEmpty() ? this.myChildDescription.addValue(this.myDomElement) : list.get(0);
        this.mySetter.invoke((Object)domElement, value);
    }

    @Override
    public T getValue() throws IllegalAccessException, InvocationTargetException {
        if (!this.myDomElement.isValid()) {
            return null;
        }
        List<? extends DomElement> list = this.myChildDescription.getValues(this.myDomElement);
        return (T)(list.isEmpty() ? null : this.myGetter.invoke((Object)list.get(0), new Object[0]));
    }
}

