/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class TooltipUtils {
    @NonNls
    private static final String MESSAGE_DELIMITER = "<hr size=1 noshade>";

    public static String getTooltipText(List<DomElementProblemDescriptor> annotations) {
        if (annotations.size() == 0) {
            return null;
        }
        return TooltipUtils.getTooltipText(TooltipUtils.getMessages(annotations));
    }

    public static String getTooltipText(List<DomElementProblemDescriptor> annotations, String[] messages) {
        return TooltipUtils.getTooltipText(ArrayUtil.mergeArrays((String[])TooltipUtils.getMessages(annotations), (String[])messages));
    }

    private static String[] getMessages(List<DomElementProblemDescriptor> problems) {
        String[] messages = new String[problems.size()];
        for (int i = 0; i < problems.size(); ++i) {
            messages[i] = problems.get(i).getDescriptionTemplate();
        }
        return messages;
    }

    public static String getTooltipText(String[] messages) {
        if (messages.length == 0) {
            return null;
        }
        StringBuilder text = new StringBuilder("<html><body><table><tr><td>&nbsp;</td><td>");
        int len = messages.length > 10 ? 10 : messages.length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                text.append(MESSAGE_DELIMITER);
            }
            text.append(messages[i]);
        }
        if (messages.length > 10) {
            text.append(MESSAGE_DELIMITER);
            text.append("...");
        }
        text.append("</td><td>&nbsp;</td></tr></table></body></html>");
        return text.toString();
    }
}

