/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log;

import com.intellij.vcs.log.VcsLogHighlighter;
import java.awt.Color;
import java.util.Collection;

public class VcsCommitStyleFactory {
    public static VcsLogHighlighter.VcsCommitStyle createStyle(Color foreground, Color background) {
        return new VcsCommitStyleImpl(foreground, background);
    }

    public static VcsLogHighlighter.VcsCommitStyle foreground(Color foreground) {
        return VcsCommitStyleFactory.createStyle(foreground, null);
    }

    public static VcsLogHighlighter.VcsCommitStyle background(Color background) {
        return VcsCommitStyleFactory.createStyle(null, background);
    }

    public static VcsLogHighlighter.VcsCommitStyle combine(Collection<VcsLogHighlighter.VcsCommitStyle> styles) {
        Color foreground = null;
        Color background = null;
        for (VcsLogHighlighter.VcsCommitStyle style : styles) {
            if (foreground == null && style.getForeground() != null) {
                foreground = style.getForeground();
            }
            if (background == null && style.getBackground() != null) {
                background = style.getBackground();
            }
            if (background == null || foreground == null) continue;
            break;
        }
        return VcsCommitStyleFactory.createStyle(foreground, background);
    }

    private static class VcsCommitStyleImpl
    implements VcsLogHighlighter.VcsCommitStyle {
        private final Color myForeground;
        private final Color myBackground;

        public VcsCommitStyleImpl(Color foreground, Color background) {
            this.myForeground = foreground;
            this.myBackground = background;
        }

        @Override
        public Color getForeground() {
            return this.myForeground;
        }

        @Override
        public Color getBackground() {
            return this.myBackground;
        }
    }
}

