/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class PseudoImplementProxy {
    public static <T, Impl> T create(Class<T> theInterface, final Impl implementation) {
        PseudoImplementProxy.checkMethodsExist(theInterface, implementation);
        final Class<?> implementationClass = implementation.getClass();
        return (T)Proxy.newProxyInstance(theInterface.getClassLoader(), new Class[]{theInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Method implementationClassMethod = implementationClass.getMethod(method.getName(), method.getParameterTypes());
                implementationClassMethod.setAccessible(true);
                return implementationClassMethod.invoke(implementation, args);
            }
        });
    }

    private static <T, Impl> void checkMethodsExist(Class<T> theInterface, Impl implementation) {
        Method[] methods;
        Class<?> implementationClass = implementation.getClass();
        for (Method method : methods = theInterface.getDeclaredMethods()) {
            try {
                implementationClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }
}

