/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.evaluation;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;

public abstract class XDebuggerEditorsProviderBase
extends XDebuggerEditorsProvider {
    @Override
    public final Document createDocument(Project project, String text, XSourcePosition sourcePosition, EvaluationMode mode) {
        PsiElement context = null;
        if (sourcePosition != null) {
            context = this.getContextElement(sourcePosition.getFile(), sourcePosition.getOffset(), project);
        }
        PsiFile codeFragment = this.createExpressionCodeFragment(project, text, context, true);
        Document document = PsiDocumentManager.getInstance(project).getDocument(codeFragment);
        assert (document != null);
        return document;
    }

    @Override
    public Document createDocument(Project project, XExpression expression, XSourcePosition sourcePosition, EvaluationMode mode) {
        PsiElement context = null;
        if (sourcePosition != null) {
            context = this.getContextElement(sourcePosition.getFile(), sourcePosition.getOffset(), project);
        }
        PsiFile codeFragment = this.createExpressionCodeFragment(project, expression, context, true);
        Document document = PsiDocumentManager.getInstance(project).getDocument(codeFragment);
        assert (document != null);
        return document;
    }

    protected abstract PsiFile createExpressionCodeFragment(Project var1, String var2, PsiElement var3, boolean var4);

    protected PsiFile createExpressionCodeFragment(Project project, XExpression expression, PsiElement context, boolean isPhysical) {
        return this.createExpressionCodeFragment(project, expression.getExpression(), context, isPhysical);
    }

    protected PsiElement getContextElement(VirtualFile virtualFile, int offset, Project project) {
        return XDebuggerUtil.getInstance().findContextElement(virtualFile, offset, project, false);
    }
}

