/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;

public class PathInfo {
    private final VirtualFile child;
    private final VirtualFile root;
    private final boolean isLibrary;
    String moduleName;
    private String computedPath;

    public PathInfo(VirtualFile child, VirtualFile root, String moduleName, boolean isLibrary) {
        this.child = child;
        this.root = root;
        this.moduleName = moduleName;
        this.isLibrary = isLibrary;
    }

    public PathInfo(VirtualFile child, VirtualFile root) {
        this(child, root, null, false);
    }

    public VirtualFile getChild() {
        return this.child;
    }

    public VirtualFile getRoot() {
        return this.root;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getPath() {
        if (this.computedPath == null) {
            StringBuilder builder = new StringBuilder();
            if (this.moduleName != null) {
                builder.append(this.moduleName).append('/');
            }
            if (this.isLibrary) {
                builder.append(this.root.getName()).append('/');
            }
            this.computedPath = builder.append(VfsUtilCore.getRelativePath(this.child, this.root, '/')).toString();
        }
        return this.computedPath;
    }
}

