/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.util.Getter;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;

class DonePromise<T>
extends Promise<T>
implements Getter<T> {
    private final T result;

    public DonePromise(T result) {
        this.result = result;
    }

    @Override
    public Promise<T> done(Consumer<T> done) {
        if (!AsyncPromise.isObsolete(done)) {
            done.consume(this.result);
        }
        return this;
    }

    @Override
    public Promise<T> processed(AsyncPromise<T> fulfilled) {
        fulfilled.setResult(this.result);
        return this;
    }

    @Override
    public Promise<T> processed(Consumer<T> processed) {
        this.done(processed);
        return this;
    }

    @Override
    public Promise<T> rejected(Consumer<Throwable> rejected) {
        return this;
    }

    @Override
    public <SUB_RESULT> Promise<SUB_RESULT> then(Function<T, SUB_RESULT> done) {
        if (done instanceof Obsolescent && ((Obsolescent)done).isObsolete()) {
            return Promise.reject("obsolete");
        }
        return Promise.resolve(done.fun(this.result));
    }

    @Override
    public <SUB_RESULT> Promise<SUB_RESULT> then(AsyncFunction<T, SUB_RESULT> done) {
        return done.fun(this.result);
    }

    @Override
    public Promise.State getState() {
        return Promise.State.FULFILLED;
    }

    public T get() {
        return this.result;
    }

    @Override
    void notify(AsyncPromise<T> child) {
        child.setResult(this.result);
    }
}

