/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.util.Getter;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class PromiseManager<HOST, VALUE> {
    private final AtomicFieldUpdater<HOST, Promise<VALUE>> fieldUpdater;

    public PromiseManager(AtomicFieldUpdater<HOST, Promise<VALUE>> fieldUpdater) {
        this.fieldUpdater = fieldUpdater;
    }

    public PromiseManager(Class<HOST> ownerClass) {
        this.fieldUpdater = AtomicFieldUpdater.forFieldOfType(ownerClass, Promise.class);
    }

    public boolean isUpToDate(HOST host, VALUE value) {
        return true;
    }

    public abstract Promise<VALUE> load(HOST var1);

    public final void reset(HOST host) {
        this.fieldUpdater.set(host, null);
    }

    public final void set(HOST host, VALUE value) {
        if (value == null) {
            this.reset(host);
        } else {
            ((AsyncPromise)this.getOrCreateAsyncResult(host, false, false)).setResult(value);
        }
    }

    public final boolean has(HOST host) {
        Promise result = (Promise)this.fieldUpdater.get(host);
        return result != null && result.getState() == Promise.State.FULFILLED;
    }

    public final Promise.State getState(HOST host) {
        Promise result = (Promise)this.fieldUpdater.get(host);
        return result == null ? null : result.getState();
    }

    public final Promise<VALUE> get(HOST host) {
        return this.get(host, true);
    }

    public final Promise<VALUE> get(HOST host, boolean checkFreshness) {
        return this.getOrCreateAsyncResult(host, checkFreshness, true);
    }

    private Promise<VALUE> getOrCreateAsyncResult(HOST host, boolean checkFreshness, boolean load) {
        AsyncPromise promise = (AsyncPromise)this.fieldUpdater.get(host);
        if (promise == null) {
            promise = new AsyncPromise();
            if (!this.fieldUpdater.compareAndSet(host, null, promise)) {
                return (Promise)this.fieldUpdater.get(host);
            }
        } else {
            Promise.State state = ((Promise)promise).getState();
            if (state == Promise.State.PENDING) {
                return promise;
            }
            if (state == Promise.State.FULFILLED) {
                if (!checkFreshness || this.isUpToDate(host, ((Getter)promise).get())) {
                    return promise;
                }
                if (!this.fieldUpdater.compareAndSet(host, promise, promise = new AsyncPromise())) {
                    Promise valueFromAnotherThread = (Promise)this.fieldUpdater.get(host);
                    while (valueFromAnotherThread == null) {
                        if (this.fieldUpdater.compareAndSet(host, null, promise)) {
                            return this.getPromise(host, load, promise);
                        }
                        valueFromAnotherThread = (Promise)this.fieldUpdater.get(host);
                    }
                    return valueFromAnotherThread;
                }
            }
        }
        return this.getPromise(host, load, promise);
    }

    private Promise<VALUE> getPromise(HOST host, boolean load, Promise<VALUE> promise) {
        if (!load || promise.getState() != Promise.State.PENDING) {
            return promise;
        }
        Promise<VALUE> effectivePromise = this.load(host);
        if (effectivePromise != promise) {
            this.fieldUpdater.compareAndSet(host, promise, effectivePromise);
            effectivePromise.notify((AsyncPromise)promise);
        }
        return effectivePromise;
    }
}

