/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.util.Consumer;
import com.intellij.util.Function;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

class RejectedPromise<T>
extends Promise<T> {
    private final Throwable error;

    public RejectedPromise(Throwable error) {
        this.error = error;
    }

    @Override
    public Promise<T> done(Consumer<T> done) {
        return this;
    }

    @Override
    public Promise<T> processed(AsyncPromise<T> fulfilled) {
        fulfilled.setError(this.error);
        return this;
    }

    @Override
    public Promise<T> rejected(Consumer<Throwable> rejected) {
        if (!AsyncPromise.isObsolete(rejected)) {
            rejected.consume((Object)this.error);
        }
        return this;
    }

    @Override
    public RejectedPromise<T> processed(Consumer<T> processed) {
        processed.consume(null);
        return this;
    }

    @Override
    public <SUB_RESULT> Promise<SUB_RESULT> then(Function<T, SUB_RESULT> done) {
        return this;
    }

    @Override
    public <SUB_RESULT> Promise<SUB_RESULT> then(AsyncFunction<T, SUB_RESULT> done) {
        return this;
    }

    @Override
    public Promise.State getState() {
        return Promise.State.REJECTED;
    }

    @Override
    void notify(AsyncPromise<T> child) {
        child.setError(this.error);
    }
}

