/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.ex;

import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.JpsModel;

public abstract class JpsElementBase<Self extends JpsElementBase<Self>>
implements JpsElement,
JpsElement.BulkModificationSupport<Self> {
    protected JpsElementBase myParent;

    protected JpsElementBase() {
    }

    public void setParent(JpsElementBase<?> parent) {
        if (this.myParent != null && parent != null) {
            throw new AssertionError((Object)("Parent for " + this + " is already set: " + this.myParent));
        }
        this.myParent = parent;
    }

    protected void fireElementChanged() {
        JpsEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.fireElementChanged(this);
        }
    }

    protected static void setParent(JpsElement element, JpsElementBase<?> parent) {
        ((JpsElementBase)element).setParent(parent);
    }

    protected JpsEventDispatcher getEventDispatcher() {
        if (this.myParent != null) {
            return this.myParent.getEventDispatcher();
        }
        return null;
    }

    protected JpsModel getModel() {
        if (this.myParent != null) {
            return this.myParent.getModel();
        }
        return null;
    }

    @Override
    public JpsElement.BulkModificationSupport<?> getBulkModificationSupport() {
        return this;
    }

    @Override
    public abstract Self createCopy();

    @Override
    public abstract void applyChanges(Self var1);

    public JpsElementBase getParent() {
        return this.myParent;
    }
}

