/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java;

import com.intellij.openapi.util.Comparing;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.ex.JpsElementBase;

public class JavaSourceRootProperties
extends JpsElementBase<JavaSourceRootProperties>
implements JpsSimpleElement<JavaSourceRootProperties> {
    private String myPackagePrefix = "";
    private boolean myForGeneratedSources;

    public JavaSourceRootProperties() {
    }

    public JavaSourceRootProperties(String packagePrefix) {
        this.myPackagePrefix = packagePrefix;
    }

    public JavaSourceRootProperties(String packagePrefix, boolean forGeneratedSources) {
        this.myPackagePrefix = packagePrefix;
        this.myForGeneratedSources = forGeneratedSources;
    }

    public String getPackagePrefix() {
        return this.myPackagePrefix;
    }

    @Override
    public JavaSourceRootProperties createCopy() {
        return new JavaSourceRootProperties(this.myPackagePrefix, this.myForGeneratedSources);
    }

    public boolean isForGeneratedSources() {
        return this.myForGeneratedSources;
    }

    public void setPackagePrefix(String packagePrefix) {
        if (!Comparing.equal((String)this.myPackagePrefix, (String)packagePrefix)) {
            this.myPackagePrefix = packagePrefix;
            this.fireElementChanged();
        }
    }

    public void setForGeneratedSources(boolean forGeneratedSources) {
        if (this.myForGeneratedSources != forGeneratedSources) {
            this.myForGeneratedSources = forGeneratedSources;
            this.fireElementChanged();
        }
    }

    @Override
    public void applyChanges(JavaSourceRootProperties modified) {
        this.setPackagePrefix(modified.myPackagePrefix);
        this.setForGeneratedSources(modified.myForGeneratedSources);
    }

    @Override
    public void setData(JavaSourceRootProperties data) {
        this.applyChanges(data);
    }

    @Override
    public JavaSourceRootProperties getData() {
        return this;
    }
}

