/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.PreciseRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.tools.idea.sdk.SdkLoadedCallback;
import com.android.tools.idea.sdk.SdkPackages;
import com.android.tools.idea.sdk.SdkState;
import com.android.tools.idea.sdk.remote.UpdatablePkgInfo;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSources;
import com.android.tools.idea.updater.UpdatablePackage;
import com.android.tools.idea.updater.UpdateInfoDialog;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.externalComponents.ExternalComponentSource;
import com.intellij.ide.externalComponents.UpdatableExternalComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Pair;
import com.intellij.util.concurrency.FutureResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;

public class SdkComponentSource
implements ExternalComponentSource {
    SdkSources mySources;
    SdkState mySdkState;
    public static String NAME = "Android SDK";
    private static final ILogger ILOG = new StdLogger(StdLogger.Level.ERROR);
    public static final String PREVIEW_CHANNEL = "Preview Channel";
    public static final String STABLE_CHANNEL = "Stable Channel";

    private boolean initIfNecessary() {
        if (this.mySdkState != null) {
            return true;
        }
        AndroidSdkData data = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (data == null) {
            Logger.getInstance(this.getClass()).warn("Couldn't find existing SDK");
            return false;
        }
        this.mySdkState = SdkState.getInstance((AndroidSdkData)data);
        this.mySources = this.mySdkState.getRemoteSdk().fetchSources(86400000L, ILOG);
        return true;
    }

    public void installUpdates(Collection<UpdatableExternalComponent> request) {
        ArrayList packages = Lists.newArrayList();
        for (UpdatableExternalComponent p : request) {
            packages.add((IPkgDesc)p.getKey());
        }
        new UpdateInfoDialog(true, packages).show();
    }

    public Collection<UpdatableExternalComponent> getAvailableVersions(ProgressIndicator indicator, UpdateSettings updateSettings) {
        return this.getComponents(indicator, updateSettings, true);
    }

    public Collection<UpdatableExternalComponent> getCurrentVersions() {
        return this.getComponents(null, null, false);
    }

    private Collection<UpdatableExternalComponent> getComponents(ProgressIndicator indicator, UpdateSettings settings, boolean remote) {
        ArrayList result = Lists.newArrayList();
        if (!this.initIfNecessary()) {
            return result;
        }
        Set ignored = settings != null ? Sets.newHashSet((Iterable)settings.getIgnoredBuildNumbers()) : ImmutableSet.of();
        this.mySdkState.loadSynchronously(SdkState.DEFAULT_EXPIRATION_PERIOD_MS, true, null, null, null, false);
        boolean previewChannel = settings != null && PREVIEW_CHANNEL.equals(settings.getExternalUpdateChannels().get(this.getName()));
        for (UpdatablePkgInfo info : this.mySdkState.getPackages().getConsolidatedPkgs().values()) {
            if (remote) {
                IPkgDesc desc;
                if (!info.hasRemote(previewChannel) || ignored.contains((desc = info.getRemote(previewChannel).getPkgDesc()).getInstallId())) continue;
                result.add(new UpdatablePackage(desc));
                continue;
            }
            if (!info.hasLocal()) continue;
            result.add(new UpdatablePackage(info.getLocalInfo().getDesc()));
        }
        return result;
    }

    public String getName() {
        return NAME;
    }

    public Collection<? extends Pair<String, String>> getStatuses() {
        if (!this.initIfNecessary()) {
            return ImmutableList.of();
        }
        final FutureResult resultFuture = new FutureResult();
        this.mySdkState.loadAsync(SdkState.DEFAULT_EXPIRATION_PERIOD_MS, false, new SdkLoadedCallback(false){

            public void doRun(SdkPackages packages) {
                PreciseRevision toolsRevision = null;
                PreciseRevision platformRevision = null;
                AndroidVersion platformVersion = null;
                for (LocalPkgInfo info : packages.getLocalPkgInfos()) {
                    if (info.getDesc().getType() == PkgType.PKG_TOOLS && (toolsRevision == null || toolsRevision.compareTo((FullRevision)info.getDesc().getPreciseRevision()) < 0)) {
                        toolsRevision = info.getDesc().getPreciseRevision();
                    }
                    if (info.getDesc().getType() != PkgType.PKG_PLATFORM || platformVersion != null && platformVersion.compareTo(info.getDesc().getAndroidVersion()) >= 0) continue;
                    platformRevision = info.getDesc().getPreciseRevision();
                    platformVersion = info.getDesc().getAndroidVersion();
                }
                ArrayList result = Lists.newArrayList();
                if (toolsRevision != null) {
                    result.add(Pair.create((Object)"Android SDK Tools:", (Object)toolsRevision.toString()));
                }
                if (platformVersion != null) {
                    result.add(Pair.create((Object)"Android Platform Version:", (Object)String.format("%1$s revision %2$s", platformVersion.getCodename() != null ? platformVersion.getCodename() : SdkVersionInfo.getAndroidName((int)platformVersion.getApiLevel()), platformRevision)));
                }
                resultFuture.set((Object)result);
            }
        }, null, null, false);
        try {
            return (Collection)resultFuture.get();
        }
        catch (InterruptedException e) {
            return ImmutableList.of();
        }
        catch (ExecutionException e) {
            return ImmutableList.of();
        }
    }

    public List<String> getAllChannels() {
        return ImmutableList.of((Object)STABLE_CHANNEL, (Object)PREVIEW_CHANNEL);
    }
}

