/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.tools.idea.sdk.SdkState;
import com.android.tools.idea.sdk.remote.UpdatablePkgInfo;
import com.android.tools.idea.sdk.wizard.SdkQuickfixWizard;
import com.android.tools.idea.updater.SdkComponentSource;
import com.android.tools.idea.updater.configure.NodeStateHolder;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.ui.AncestorListenerAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;

public class SdkUpdaterConfigurable
implements SearchableConfigurable {
    private SdkUpdaterConfigPanel myPanel;
    private boolean myIncludePreview;

    public String getId() {
        return "AndroidSdkUpdater";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public String getDisplayName() {
        return "Android SDK Updater";
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        AndroidSdkData data = AndroidSdkUtils.tryToChooseAndroidSdk();
        final Runnable channelChangedCallback = new Runnable(){

            @Override
            public void run() {
                boolean newIncludePreview = "Preview Channel".equals(UpdateSettings.getInstance().getExternalUpdateChannels().get(SdkComponentSource.NAME));
                if (newIncludePreview != SdkUpdaterConfigurable.this.myIncludePreview) {
                    SdkUpdaterConfigurable.this.myIncludePreview = newIncludePreview;
                    SdkUpdaterConfigurable.this.myPanel.setIncludePreview(SdkUpdaterConfigurable.this.myIncludePreview);
                }
            }
        };
        SdkState state = SdkState.getInstance((AndroidSdkData)data);
        this.myPanel = new SdkUpdaterConfigPanel(state, channelChangedCallback);
        JComponent component = this.myPanel.getComponent();
        component.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                channelChangedCallback.run();
            }
        });
        return this.myPanel.getComponent();
    }

    public boolean isModified() {
        return this.myPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myPanel.saveSources();
        HtmlBuilder message = new HtmlBuilder();
        message.openHtmlBody();
        ArrayList toDelete = Lists.newArrayList();
        ArrayList requestedPackages = Lists.newArrayList();
        for (NodeStateHolder holder : this.myPanel.getStates()) {
            if (holder.getState() == NodeStateHolder.SelectedState.NOT_INSTALLED) {
                if (!holder.getPkg().hasLocal()) continue;
                toDelete.add(holder.getPkg());
                continue;
            }
            if (holder.getState() != NodeStateHolder.SelectedState.INSTALLED || !holder.getPkg().isUpdate(this.myIncludePreview) && holder.getPkg().hasLocal()) continue;
            requestedPackages.add(holder.getPkg().getRemote(this.myIncludePreview).getPkgDesc());
        }
        boolean found = false;
        if (!toDelete.isEmpty()) {
            found = true;
            message.add("The following components will be deleted: \n");
            message.beginList();
            for (UpdatablePkgInfo item : toDelete) {
                message.listItem().add(item.getPkgDesc(this.myIncludePreview).getListDescription()).add(", Revision: ").add(item.getPkgDesc(this.myIncludePreview).getPreciseRevision().toString());
            }
            message.endList();
        }
        if (!requestedPackages.isEmpty()) {
            found = true;
            message.add("The following components will be installed: \n");
            message.beginList();
            for (UpdatablePkgInfo item : requestedPackages) {
                message.listItem().add(String.format("%1$s %2$s %3$s", item.getListDescription(), item.hasAndroidVersion() ? "revision" : "version", item.getPreciseRevision()));
            }
            message.endList();
        }
        message.closeHtmlBody();
        if (found) {
            if (Messages.showOkCancelDialog((Project)null, (String)message.getHtml(), (String)"Confirm Change", (Icon)AllIcons.General.Warning) == 0) {
                for (UpdatablePkgInfo item : toDelete) {
                    item.getLocalInfo().delete();
                }
                if (!requestedPackages.isEmpty()) {
                    SdkQuickfixWizard sdkQuickfixWizard = new SdkQuickfixWizard(null, null, (List)requestedPackages);
                    sdkQuickfixWizard.init();
                    sdkQuickfixWizard.show();
                }
                this.myPanel.refresh();
            } else {
                throw new ConfigurationException("Installation was canceled.");
            }
        }
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            this.myPanel.disposeUIResources();
        }
    }
}

