/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.tools.idea.sdk.SdkState;
import com.android.tools.idea.sdk.remote.internal.updater.SettingsController;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.tools.idea.updater.configure.SourcesTableModel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;

public class UpdateSitesPanel {
    private JPanel myRootPanel;
    private TableView myUpdateSitesTable;
    private JPanel mySourcesPanel;
    private JPanel mySourcesLoadingPanel;
    private AsyncProcessIcon mySourcesLoadingIcon;
    private JCheckBox myForceHttp;
    private SourcesTableModel mySourcesTableModel;
    private static SettingsController ourSettingsController = SettingsController.getInstance();

    public UpdateSitesPanel() {
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        this.mySourcesLoadingIcon = new AsyncProcessIcon("Loading...");
        this.mySourcesTableModel = new SourcesTableModel();
        this.myUpdateSitesTable = new TableView((ListTableModel)this.mySourcesTableModel);
        ToolbarDecorator userDefinedDecorator = ToolbarDecorator.createDecorator((JTable)this.myUpdateSitesTable);
        this.mySourcesPanel = this.addExtraActions(userDefinedDecorator).createPanel();
        SdkUpdaterConfigPanel.setTableProperties((JTable)this.myUpdateSitesTable, null);
    }

    private ToolbarDecorator addExtraActions(ToolbarDecorator decorator) {
        return decorator.setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                UpdateSitesPanel.this.mySourcesTableModel.editRow(UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRow());
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRowCount() == 1 && UpdateSitesPanel.this.mySourcesTableModel.isEditable(UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRow());
            }
        }).addExtraAction(new AnActionButton("Select All", AllIcons.Actions.Selectall){

            public void actionPerformed(AnActionEvent e) {
                for (int i = 0; i < UpdateSitesPanel.this.myUpdateSitesTable.getRowCount(); ++i) {
                    UpdateSitesPanel.this.mySourcesTableModel.setSourceEnabled(i, true);
                }
            }

            public boolean isEnabled() {
                return UpdateSitesPanel.this.myUpdateSitesTable.getRowCount() > 0;
            }
        }).addExtraAction(new AnActionButton("Deselect All", AllIcons.Actions.Unselectall){

            public void actionPerformed(AnActionEvent e) {
                for (int i = 0; i < UpdateSitesPanel.this.myUpdateSitesTable.getRowCount(); ++i) {
                    UpdateSitesPanel.this.mySourcesTableModel.setSourceEnabled(i, false);
                }
            }

            public boolean isEnabled() {
                return UpdateSitesPanel.this.myUpdateSitesTable.getRowCount() > 0;
            }
        }).setMoveDownAction(null).setMoveUpAction(null).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                if (UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRowCount() < 1) {
                    return false;
                }
                for (int i : UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRows()) {
                    if (UpdateSitesPanel.this.mySourcesTableModel.isEditable(i)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public boolean isModified() {
        return this.mySourcesTableModel.isSourcesModified() || ourSettingsController.getForceHttp() != this.myForceHttp.isSelected();
    }

    public void reset() {
        this.mySourcesTableModel.reset();
        this.myForceHttp.setSelected(ourSettingsController.getForceHttp());
    }

    public void setSdkState(SdkState state) {
        this.mySourcesTableModel.setSdkState(state);
    }

    public void save() {
        this.mySourcesTableModel.save();
        ourSettingsController.setForceHttp(this.myForceHttp.isSelected());
    }

    public void startLoading() {
        this.mySourcesLoadingPanel.setVisible(true);
    }

    public void finishLoading() {
        this.mySourcesTableModel.refreshSources();
        this.mySourcesLoadingPanel.setVisible(false);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("<html>These are the sites checked for Android SDK Updates  Tools. When unchecked, the Android Studio SDK Manager will not check the site for updates. Adding additional add-on updates sites can add new add-ons or extra SDK packages.</html>");
        jBLabel.setDisplayedMnemonic(' ');
        jBLabel.setDisplayedMnemonicIndex(58);
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(600, -1), new Dimension(600, -1)));
        JPanel jPanel3 = this.mySourcesPanel;
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySourcesLoadingPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Loading sources...");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.mySourcesLoadingIcon;
        jPanel.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myForceHttp = jCheckBox = new JCheckBox();
        jCheckBox.setText("Force https://... sources to be fetched using http://...");
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

