/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.sonatype.aether.util.artifact;

import java.util.HashMap;
import java.util.Map;
import org.gradle.mvn3.org.sonatype.aether.artifact.ArtifactType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArtifactType
implements ArtifactType {
    private final String id;
    private final String extension;
    private final String classifier;
    private final Map<String, String> properties;

    public DefaultArtifactType(String id) {
        this(id, id, "", "none", false, false);
    }

    public DefaultArtifactType(String id, String extension, String classifier, String language) {
        this(id, extension, classifier, language, true, false);
    }

    public DefaultArtifactType(String id, String extension, String classifier, String language, boolean constitutesBuildPath, boolean includesDependencies) {
        if (id == null || id.length() < 0) {
            throw new IllegalArgumentException("no type id specified");
        }
        this.id = id;
        this.extension = extension != null && extension.length() > 0 ? extension : id;
        this.classifier = classifier != null ? classifier : "";
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("type", id);
        props.put("language", language != null && language.length() > 0 ? language : "none");
        props.put("includesDependencies", Boolean.toString(includesDependencies));
        props.put("constitutesBuildPath", Boolean.toString(constitutesBuildPath));
        this.properties = props;
    }

    public String getId() {
        return this.id;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

