/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.sonatype.aether.util.artifact;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.gradle.mvn3.org.sonatype.aether.artifact.Artifact;
import org.gradle.mvn3.org.sonatype.aether.util.artifact.AbstractArtifact;
import org.gradle.mvn3.org.sonatype.aether.util.artifact.DefaultArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubArtifact
extends AbstractArtifact {
    private final Artifact mainArtifact;
    private final String classifier;
    private final String extension;
    private final File file;
    private final Map<String, String> properties;

    public SubArtifact(Artifact mainArtifact, String classifier, String extension) {
        this(mainArtifact, classifier, extension, (File)null);
    }

    public SubArtifact(Artifact mainArtifact, String classifier, String extension, File file) {
        this(mainArtifact, classifier, extension, null, file);
    }

    public SubArtifact(Artifact mainArtifact, String classifier, String extension, Map<String, String> properties) {
        this(mainArtifact, classifier, extension, properties, null);
    }

    public SubArtifact(Artifact mainArtifact, String classifier, String extension, Map<String, String> properties, File file) {
        if (mainArtifact == null) {
            throw new IllegalArgumentException("no artifact specified");
        }
        this.mainArtifact = mainArtifact;
        this.classifier = classifier;
        this.extension = extension;
        this.file = file;
        this.properties = SubArtifact.copy(properties);
    }

    private SubArtifact(Artifact mainArtifact, String classifier, String extension, File file, Map<String, String> properties) {
        this.mainArtifact = mainArtifact;
        this.classifier = classifier;
        this.extension = extension;
        this.file = file;
        this.properties = properties;
    }

    public String getGroupId() {
        return this.mainArtifact.getGroupId();
    }

    public String getArtifactId() {
        return this.mainArtifact.getArtifactId();
    }

    public String getVersion() {
        return this.mainArtifact.getVersion();
    }

    @Override
    public Artifact setVersion(String version) {
        return new DefaultArtifact(this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getExtension(), version, this.getFile(), this.getProperties());
    }

    public String getBaseVersion() {
        return this.mainArtifact.getBaseVersion();
    }

    public boolean isSnapshot() {
        return this.mainArtifact.isSnapshot();
    }

    public String getClassifier() {
        return SubArtifact.expand(this.classifier, this.mainArtifact.getClassifier());
    }

    public String getExtension() {
        return SubArtifact.expand(this.extension, this.mainArtifact.getExtension());
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public Artifact setFile(File file) {
        if (this.file == null ? file == null : this.file.equals(file)) {
            return this;
        }
        return new SubArtifact(this.mainArtifact, this.classifier, this.extension, file, this.properties);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.properties.get(key);
        return value != null ? value : defaultValue;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public Artifact setProperties(Map<String, String> properties) {
        if (((Object)this.properties).equals(properties) || properties == null && this.properties.isEmpty()) {
            return this;
        }
        return new SubArtifact(this.mainArtifact, this.classifier, this.extension, properties, this.file);
    }

    private static String expand(String pattern, String replacement) {
        String result = "";
        if (pattern != null) {
            result = pattern.replace("*", replacement);
            if (replacement.length() <= 0) {
                char c;
                int i;
                if (pattern.startsWith("*")) {
                    for (i = 0; i < result.length() && ((c = result.charAt(i)) == '-' || c == '.'); ++i) {
                    }
                    result = result.substring(i);
                }
                if (pattern.endsWith("*")) {
                    for (i = result.length() - 1; i >= 0 && ((c = result.charAt(i)) == '-' || c == '.'); --i) {
                    }
                    result = result.substring(0, i + 1);
                }
            }
        }
        return result;
    }
}

