/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.sonatype.aether.util.metadata;

import java.io.File;
import org.gradle.mvn3.org.sonatype.aether.metadata.Metadata;

public final class DefaultMetadata
implements Metadata {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String type;
    private final Metadata.Nature nature;
    private final File file;

    public DefaultMetadata(String type, Metadata.Nature nature) {
        this.version = "";
        this.artifactId = "";
        this.groupId = "";
        String string = this.type = type != null ? type : "";
        if (nature == null) {
            throw new IllegalArgumentException("metadata nature was not specified");
        }
        this.nature = nature;
        this.file = null;
    }

    public DefaultMetadata(String groupId, String type, Metadata.Nature nature) {
        this.groupId = groupId != null ? groupId : "";
        this.version = "";
        this.artifactId = "";
        String string = this.type = type != null ? type : "";
        if (nature == null) {
            throw new IllegalArgumentException("metadata nature was not specified");
        }
        this.nature = nature;
        this.file = null;
    }

    public DefaultMetadata(String groupId, String artifactId, String type, Metadata.Nature nature) {
        this.groupId = groupId != null ? groupId : "";
        this.artifactId = artifactId != null ? artifactId : "";
        this.version = "";
        String string = this.type = type != null ? type : "";
        if (nature == null) {
            throw new IllegalArgumentException("metadata nature was not specified");
        }
        this.nature = nature;
        this.file = null;
    }

    public DefaultMetadata(String groupId, String artifactId, String version, String type, Metadata.Nature nature) {
        this.groupId = groupId != null ? groupId : "";
        this.artifactId = artifactId != null ? artifactId : "";
        this.version = version != null ? version : "";
        String string = this.type = type != null ? type : "";
        if (nature == null) {
            throw new IllegalArgumentException("metadata nature was not specified");
        }
        this.nature = nature;
        this.file = null;
    }

    public DefaultMetadata(String groupId, String artifactId, String version, String type, Metadata.Nature nature, File file) {
        this.groupId = groupId != null ? groupId : "";
        this.artifactId = artifactId != null ? artifactId : "";
        this.version = version != null ? version : "";
        String string = this.type = type != null ? type : "";
        if (nature == null) {
            throw new IllegalArgumentException("metadata nature was not specified");
        }
        this.nature = nature;
        this.file = file;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public Metadata.Nature getNature() {
        return this.nature;
    }

    public File getFile() {
        return this.file;
    }

    public Metadata setFile(File file) {
        return new DefaultMetadata(this.groupId, this.artifactId, this.version, this.type, this.nature, file);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        if (this.getGroupId().length() > 0) {
            buffer.append(this.getGroupId());
        }
        if (this.getArtifactId().length() > 0) {
            buffer.append(':').append(this.getArtifactId());
        }
        if (this.getVersion().length() > 0) {
            buffer.append(':').append(this.getVersion());
        }
        buffer.append('/').append(this.getType());
        return buffer.toString();
    }
}

