/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.io;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.UnsafeUtil;
import com.esotericsoftware.kryo.util.Util;
import java.io.OutputStream;
import java.nio.ByteOrder;

public final class UnsafeOutput
extends Output {
    private boolean supportVarInts = false;
    private static final boolean isLittleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);

    public UnsafeOutput() {
    }

    public UnsafeOutput(int n) {
        this(n, n);
    }

    public UnsafeOutput(int n, int n2) {
        super(n, n2);
    }

    public UnsafeOutput(byte[] byArray) {
        this(byArray, byArray.length);
    }

    public UnsafeOutput(byte[] byArray, int n) {
        super(byArray, n);
    }

    public UnsafeOutput(OutputStream outputStream) {
        super(outputStream);
    }

    public UnsafeOutput(OutputStream outputStream, int n) {
        super(outputStream, n);
    }

    @Override
    public final void writeInt(int n) throws KryoException {
        this.require(4);
        UnsafeUtil.unsafe().putInt(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, n);
        this.position += 4;
    }

    private final void writeLittleEndianInt(int n) {
        if (isLittleEndian) {
            this.writeInt(n);
        } else {
            this.writeInt(Util.swapInt(n));
        }
    }

    @Override
    public final void writeFloat(float f) throws KryoException {
        this.require(4);
        UnsafeUtil.unsafe().putFloat(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, f);
        this.position += 4;
    }

    @Override
    public final void writeShort(int n) throws KryoException {
        this.require(2);
        UnsafeUtil.unsafe().putShort(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, (short)n);
        this.position += 2;
    }

    @Override
    public final void writeLong(long l) throws KryoException {
        this.require(8);
        UnsafeUtil.unsafe().putLong(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, l);
        this.position += 8;
    }

    private final void writeLittleEndianLong(long l) {
        if (isLittleEndian) {
            this.writeLong(l);
        } else {
            this.writeLong(Util.swapLong(l));
        }
    }

    @Override
    public final void writeDouble(double d) throws KryoException {
        this.require(8);
        UnsafeUtil.unsafe().putDouble(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, d);
        this.position += 8;
    }

    @Override
    public final int writeInt(int n, boolean bl) throws KryoException {
        if (!this.supportVarInts) {
            this.writeInt(n);
            return 4;
        }
        return this.writeVarInt(n, bl);
    }

    @Override
    public final int writeLong(long l, boolean bl) throws KryoException {
        if (!this.supportVarInts) {
            this.writeLong(l);
            return 8;
        }
        return this.writeVarLong(l, bl);
    }

    @Override
    public final int writeVarInt(int n, boolean bl) throws KryoException {
        int n2 = n;
        if (!bl) {
            n2 = n2 << 1 ^ n2 >> 31;
        }
        int n3 = 0;
        n3 = n2 & 0x7F;
        if ((n2 >>>= 7) == 0) {
            this.write(n3);
            return 1;
        }
        n3 |= 0x80;
        n3 |= (n2 & 0x7F) << 8;
        if ((n2 >>>= 7) == 0) {
            this.writeLittleEndianInt(n3);
            this.position -= 2;
            return 2;
        }
        n3 |= 0x8000;
        n3 |= (n2 & 0x7F) << 16;
        if ((n2 >>>= 7) == 0) {
            this.writeLittleEndianInt(n3);
            --this.position;
            return 3;
        }
        n3 |= 0x800000;
        n3 |= (n2 & 0x7F) << 24;
        if ((n2 >>>= 7) == 0) {
            this.writeLittleEndianInt(n3);
            this.position -= 0;
            return 4;
        }
        long l = (long)(n3 |= Integer.MIN_VALUE) | (long)(n2 & 0x7F) << 32;
        n3 = (int)((long)n3 & 0xFFFFFFFFL);
        this.writeLittleEndianLong(l);
        this.position -= 3;
        return 5;
    }

    @Override
    public final int writeVarLong(long l, boolean bl) throws KryoException {
        if (!bl) {
            l = l << 1 ^ l >> 63;
        }
        int n = 0;
        n = (int)(l & 0x7FL);
        if ((l >>>= 7) == 0L) {
            this.writeByte(n);
            return 1;
        }
        n |= 0x80;
        n = (int)((long)n | l << 8);
        if ((l >>>= 7) == 0L) {
            this.writeLittleEndianInt(n);
            this.position -= 2;
            return 2;
        }
        n |= 0x8000;
        n = (int)((long)n | l << 16);
        if ((l >>>= 7) == 0L) {
            this.writeLittleEndianInt(n);
            --this.position;
            return 3;
        }
        n |= 0x800000;
        n = (int)((long)n | l << 24);
        if ((l >>>= 7) == 0L) {
            this.writeLittleEndianInt(n);
            this.position -= 0;
            return 4;
        }
        long l2 = (long)(n |= Integer.MIN_VALUE) | l << 32;
        if ((l >>>= 7) == 0L) {
            this.writeLittleEndianLong(l2);
            this.position -= 3;
            return 5;
        }
        l2 |= 0x80L;
        l2 = (long)n | l << 40;
        if ((l >>>= 7) == 0L) {
            this.writeLittleEndianLong(l2);
            this.position -= 2;
            return 6;
        }
        l2 |= 0x8000L;
        l2 = (long)n | l << 48;
        if ((l >>>= 7) == 0L) {
            this.writeLittleEndianLong(l2);
            --this.position;
            return 7;
        }
        l2 |= 0x800000L;
        l2 = (long)n | l << 56;
        if ((l >>>= 7) == 0L) {
            this.writeLittleEndianLong(l2);
            return 8;
        }
        this.writeLittleEndianLong(l2 |= Integer.MIN_VALUE);
        this.write((byte)(l >>> 7));
        return 9;
    }

    @Override
    public final void writeInts(int[] nArray, boolean bl) throws KryoException {
        if (!this.supportVarInts) {
            int n = nArray.length << 2;
            this.writeBytes(nArray, UnsafeUtil.intArrayBaseOffset, 0L, n);
        } else {
            super.writeInts(nArray, bl);
        }
    }

    @Override
    public final void writeLongs(long[] lArray, boolean bl) throws KryoException {
        if (!this.supportVarInts) {
            int n = lArray.length << 3;
            this.writeBytes(lArray, UnsafeUtil.longArrayBaseOffset, 0L, n);
        } else {
            super.writeLongs(lArray, bl);
        }
    }

    @Override
    public final void writeInts(int[] nArray) throws KryoException {
        int n = nArray.length << 2;
        this.writeBytes(nArray, UnsafeUtil.intArrayBaseOffset, 0L, n);
    }

    @Override
    public final void writeLongs(long[] lArray) throws KryoException {
        int n = lArray.length << 3;
        this.writeBytes(lArray, UnsafeUtil.longArrayBaseOffset, 0L, n);
    }

    @Override
    public final void writeFloats(float[] fArray) throws KryoException {
        int n = fArray.length << 2;
        this.writeBytes(fArray, UnsafeUtil.floatArrayBaseOffset, 0L, n);
    }

    @Override
    public final void writeShorts(short[] sArray) throws KryoException {
        int n = sArray.length << 1;
        this.writeBytes(sArray, UnsafeUtil.shortArrayBaseOffset, 0L, n);
    }

    @Override
    public final void writeChars(char[] cArray) throws KryoException {
        int n = cArray.length << 1;
        this.writeBytes(cArray, UnsafeUtil.charArrayBaseOffset, 0L, n);
    }

    @Override
    public final void writeDoubles(double[] dArray) throws KryoException {
        int n = dArray.length << 3;
        this.writeBytes(dArray, UnsafeUtil.doubleArrayBaseOffset, 0L, n);
    }

    public final void writeBytes(Object object, long l, long l2) throws KryoException {
        this.writeBytes(object, 0L, l, l2);
    }

    private final void writeBytes(Object object, long l, long l2, long l3) throws KryoException {
        int n = Math.min(this.capacity - this.position, (int)l3);
        while (true) {
            UnsafeUtil.unsafe().copyMemory(object, l + l2, this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, n);
            this.position += n;
            if ((l3 -= (long)n) == 0L) {
                return;
            }
            l2 += (long)n;
            n = Math.min(this.capacity, (int)l3);
            this.require(n);
        }
    }

    public boolean supportVarInts() {
        return this.supportVarInts;
    }

    public void supportVarInts(boolean bl) {
        this.supportVarInts = bl;
    }
}

