/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.ArrayList;
import java.util.Collection;

public class CollectionSerializer
extends Serializer<Collection> {
    private boolean elementsCanBeNull = true;
    private Serializer serializer;
    private Class elementClass;
    private Class genericType;

    public CollectionSerializer() {
    }

    public CollectionSerializer(Class clazz, Serializer serializer) {
        this.setElementClass(clazz, serializer);
    }

    public CollectionSerializer(Class clazz, Serializer serializer, boolean bl) {
        this.setElementClass(clazz, serializer);
        this.elementsCanBeNull = bl;
    }

    public void setElementsCanBeNull(boolean bl) {
        this.elementsCanBeNull = bl;
    }

    public void setElementClass(Class clazz, Serializer serializer) {
        this.elementClass = clazz;
        this.serializer = serializer;
    }

    @Override
    public void setGenerics(Kryo kryo, Class[] classArray) {
        this.genericType = null;
        if (classArray != null && classArray.length > 0 && kryo.isFinal(classArray[0])) {
            this.genericType = classArray[0];
        }
    }

    @Override
    public void write(Kryo kryo, Output output, Collection collection) {
        int n = collection.size();
        output.writeVarInt(n, true);
        Serializer serializer = this.serializer;
        if (this.genericType != null) {
            if (serializer == null) {
                serializer = kryo.getSerializer(this.genericType);
            }
            this.genericType = null;
        }
        if (serializer != null) {
            if (this.elementsCanBeNull) {
                for (Object e : collection) {
                    kryo.writeObjectOrNull(output, e, serializer);
                }
            } else {
                for (Object e : collection) {
                    kryo.writeObject(output, e, serializer);
                }
            }
        } else {
            for (Object e : collection) {
                kryo.writeClassAndObject(output, e);
            }
        }
    }

    protected Collection create(Kryo kryo, Input input, Class<Collection> clazz) {
        return kryo.newInstance(clazz);
    }

    @Override
    public Collection read(Kryo kryo, Input input, Class<Collection> clazz) {
        Collection collection = this.create(kryo, input, clazz);
        kryo.reference(collection);
        int n = input.readVarInt(true);
        if (collection instanceof ArrayList) {
            ((ArrayList)collection).ensureCapacity(n);
        }
        Class clazz2 = this.elementClass;
        Serializer serializer = this.serializer;
        if (this.genericType != null) {
            if (serializer == null) {
                clazz2 = this.genericType;
                serializer = kryo.getSerializer(this.genericType);
            }
            this.genericType = null;
        }
        if (serializer != null) {
            if (this.elementsCanBeNull) {
                for (int i = 0; i < n; ++i) {
                    collection.add(kryo.readObjectOrNull(input, clazz2, serializer));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    collection.add(kryo.readObject(input, clazz2, serializer));
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                collection.add(kryo.readClassAndObject(input));
            }
        }
        return collection;
    }

    protected Collection createCopy(Kryo kryo, Collection collection) {
        return (Collection)kryo.newInstance(collection.getClass());
    }

    @Override
    public Collection copy(Kryo kryo, Collection collection) {
        Collection collection2 = this.createCopy(kryo, collection);
        kryo.reference(collection2);
        for (Object e : collection) {
            collection2.add(kryo.copy(e));
        }
        return collection2;
    }
}

