/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import com.intellij.openapi.util.Comparing;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jetbrains.annotations.NonNls;
import org.picocontainer.PicoContainer;

public abstract class KeyedExtensionFactory<T, KeyT> {
    private final Class<T> myInterfaceClass;
    private final ExtensionPointName<KeyedFactoryEPBean> myEpName;
    private final PicoContainer myPicoContainer;

    public KeyedExtensionFactory(Class<T> interfaceClass, @NonNls ExtensionPointName<KeyedFactoryEPBean> epName, PicoContainer picoContainer) {
        this.myInterfaceClass = interfaceClass;
        this.myEpName = epName;
        this.myPicoContainer = picoContainer;
    }

    public T get() {
        final KeyedFactoryEPBean[] epBeans = Extensions.getExtensions(this.myEpName);
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object keyArg = args[0];
                String key = KeyedExtensionFactory.this.getKey(keyArg);
                Object result = KeyedExtensionFactory.this.getByKey(epBeans, key, method, args);
                if (result == null) {
                    result = KeyedExtensionFactory.this.getByKey(epBeans, null, method, args);
                }
                return result;
            }
        };
        return (T)Proxy.newProxyInstance(this.myInterfaceClass.getClassLoader(), new Class[]{this.myInterfaceClass}, handler);
    }

    public T getByKey(KeyT key) {
        KeyedFactoryEPBean[] epBeans;
        for (KeyedFactoryEPBean epBean : epBeans = Extensions.getExtensions(this.myEpName)) {
            if (!Comparing.strEqual((String)this.getKey(key), (String)epBean.key)) continue;
            try {
                if (epBean.implementationClass == null) continue;
                return epBean.instantiate(epBean.implementationClass, this.myPicoContainer);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private T getByKey(KeyedFactoryEPBean[] epBeans, String key, Method method, Object[] args) {
        Object result = null;
        for (KeyedFactoryEPBean epBean : epBeans) {
            if (!Comparing.strEqual((String)epBean.key, (String)key, (boolean)true)) continue;
            try {
                if (epBean.implementationClass != null) {
                    result = epBean.instantiate(epBean.implementationClass, this.myPicoContainer);
                } else {
                    Object factory = epBean.instantiate(epBean.factoryClass, this.myPicoContainer);
                    result = method.invoke(factory, args);
                }
                if (result == null) continue;
                break;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (T)result;
    }

    public abstract String getKey(KeyT var1);
}

