/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.gradle.internal.resource.PasswordCredentials;
import org.gradle.internal.resource.UriResource;
import org.gradle.internal.resource.transport.http.HttpProxySettings;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.gradle.internal.resource.transport.http.ntlm.NTLMCredentials;
import org.gradle.internal.resource.transport.http.ntlm.NTLMSchemeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientConfigurer.class);
    private final HttpSettings httpSettings;

    public HttpClientConfigurer(HttpSettings httpSettings) {
        this.httpSettings = httpSettings;
    }

    public void configure(DefaultHttpClient httpClient) {
        NTLMSchemeFactory.register(httpClient);
        this.configureCredentials(httpClient, this.httpSettings.getCredentials());
        this.configureProxyCredentials(httpClient, this.httpSettings.getProxySettings());
        this.configureRetryHandler(httpClient);
        this.configureUserAgent(httpClient);
    }

    private void configureCredentials(DefaultHttpClient httpClient, PasswordCredentials credentials) {
        String username;
        if (credentials != null && (username = credentials.getUsername()) != null && username.length() > 0) {
            this.useCredentials(httpClient, credentials, AuthScope.ANY_HOST, -1);
            httpClient.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuth((AuthScheme)new BasicScheme()), 0);
        }
    }

    private void configureProxyCredentials(DefaultHttpClient httpClient, HttpProxySettings proxySettings) {
        HttpProxySettings.HttpProxy proxy = proxySettings.getProxy();
        if (proxy != null && proxy.credentials != null) {
            this.useCredentials(httpClient, proxy.credentials, proxy.host, proxy.port);
        }
    }

    private void useCredentials(DefaultHttpClient httpClient, PasswordCredentials credentials, String host, int port) {
        UsernamePasswordCredentials basicCredentials = new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword());
        httpClient.getCredentialsProvider().setCredentials(new AuthScope(host, port), (Credentials)basicCredentials);
        NTLMCredentials ntlmCredentials = new NTLMCredentials(credentials);
        NTCredentials ntCredentials = new NTCredentials(ntlmCredentials.getUsername(), ntlmCredentials.getPassword(), ntlmCredentials.getWorkstation(), ntlmCredentials.getDomain());
        httpClient.getCredentialsProvider().setCredentials(new AuthScope(host, port, AuthScope.ANY_REALM, "NTLM"), (Credentials)ntCredentials);
        LOGGER.debug("Using {} and {} for authenticating against '{}:{}'", new Object[]{credentials, ntlmCredentials, host, port});
    }

    private void configureRetryHandler(DefaultHttpClient httpClient) {
        httpClient.setHttpRequestRetryHandler(new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                return false;
            }
        });
    }

    public void configureUserAgent(DefaultHttpClient httpClient) {
        HttpProtocolParams.setUserAgent((HttpParams)httpClient.getParams(), (String)UriResource.getUserAgentString());
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        private final AuthScheme authScheme;

        PreemptiveAuth(AuthScheme authScheme) {
            this.authScheme = authScheme;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() != null || authState.hasAuthOptions()) {
                return;
            }
            String requestMethod = request.getRequestLine().getMethod();
            if (requestMethod.equals("PUT") || requestMethod.equals("POST")) {
                HttpHost targetHost;
                CredentialsProvider credentialsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                Credentials credentials = credentialsProvider.getCredentials(new AuthScope((targetHost = (HttpHost)context.getAttribute("http.target_host")).getHostName(), targetHost.getPort()));
                if (credentials == null) {
                    throw new HttpException("No credentials for preemptive authentication");
                }
                authState.update(this.authScheme, credentials);
            }
        }
    }
}

