/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.google.common.collect.Sets;
import java.util.Set;
import org.gradle.internal.resource.PasswordCredentials;
import org.gradle.internal.resource.connector.ResourceConnectorFactory;
import org.gradle.internal.resource.connector.ResourceConnectorSpecification;
import org.gradle.internal.resource.transfer.DefaultExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transport.http.DefaultHttpSettings;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.HttpResourceAccessor;
import org.gradle.internal.resource.transport.http.HttpResourceLister;
import org.gradle.internal.resource.transport.http.HttpResourceUploader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpConnectorFactory
implements ResourceConnectorFactory {
    public Set<String> getSupportedProtocols() {
        return Sets.newHashSet((Object[])new String[]{"http", "https"});
    }

    public ExternalResourceConnector createResourceConnector(ResourceConnectorSpecification connectionDetails) {
        HttpClientHelper http = new HttpClientHelper(new DefaultHttpSettings((PasswordCredentials)connectionDetails.getCredentials(PasswordCredentials.class)));
        HttpResourceAccessor accessor = new HttpResourceAccessor(http);
        HttpResourceLister lister = new HttpResourceLister(accessor);
        HttpResourceUploader uploader = new HttpResourceUploader(http);
        return new DefaultExternalResourceConnector((ExternalResourceAccessor)accessor, (ExternalResourceLister)lister, (ExternalResourceUploader)uploader);
    }
}

