/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.gradle.internal.resource.local.LocalResource;

public class RepeatableInputStreamEntity
extends AbstractHttpEntity {
    private final LocalResource source;

    public RepeatableInputStreamEntity(LocalResource source, ContentType contentType) {
        this.source = source;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.source.getContentLength();
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        return this.source.open();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        IOUtils.copyLarge((InputStream)this.getContent(), (OutputStream)outstream);
    }

    public boolean isStreaming() {
        return true;
    }
}

