/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.artifact.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.JpsArtifactReference;
import org.jetbrains.jps.model.artifact.JpsArtifactService;
import org.jetbrains.jps.model.artifact.JpsArtifactType;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.impl.JpsArtifactImpl;
import org.jetbrains.jps.model.artifact.impl.JpsArtifactReferenceImpl;
import org.jetbrains.jps.model.artifact.impl.JpsArtifactRole;

public class JpsArtifactServiceImpl
extends JpsArtifactService {
    public List<JpsArtifact> getArtifacts(JpsProject project) {
        JpsElementCollection collection = (JpsElementCollection)project.getContainer().getChild(JpsArtifactRole.ARTIFACT_COLLECTION_ROLE);
        return collection != null ? collection.getElements() : Collections.emptyList();
    }

    public List<JpsArtifact> getSortedArtifacts(JpsProject project) {
        ArrayList<JpsArtifact> artifacts = new ArrayList<JpsArtifact>(this.getArtifacts(project));
        Collections.sort(artifacts, new Comparator<JpsArtifact>(){

            @Override
            public int compare(JpsArtifact o1, JpsArtifact o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return artifacts;
    }

    public <P extends JpsElement> JpsArtifact addArtifact(JpsProject project, String name, JpsCompositePackagingElement rootElement, JpsArtifactType<P> type, P properties) {
        JpsArtifact artifact = this.createArtifact(name, rootElement, type, properties);
        return (JpsArtifact)((JpsElementCollection)project.getContainer().getOrSetChild(JpsArtifactRole.ARTIFACT_COLLECTION_ROLE)).addChild((JpsElement)artifact);
    }

    public <P extends JpsElement> JpsArtifact createArtifact(String name, JpsCompositePackagingElement rootElement, JpsArtifactType<P> type, P properties) {
        return new JpsArtifactImpl<P>(name, rootElement, type, properties);
    }

    public JpsArtifactReference createReference(String artifactName) {
        return new JpsArtifactReferenceImpl(artifactName);
    }
}

