/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.ex;

import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementContainer;
import org.jetbrains.jps.model.JpsElementCreator;
import org.jetbrains.jps.model.JpsElementParameterizedCreator;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementContainerEx;

public class JpsElementContainerImpl
extends JpsElementContainerEx
implements JpsElementContainer {
    private final Map<JpsElementChildRole<?>, JpsElement> myElements = new THashMap(1);
    private final JpsCompositeElementBase<?> myParent;

    public JpsElementContainerImpl(JpsCompositeElementBase<?> parent) {
        this.myParent = parent;
    }

    public JpsElementContainerImpl(JpsElementContainerEx original, JpsCompositeElementBase<?> parent) {
        this.myParent = parent;
        for (Map.Entry entry : original.getElementsMap().entrySet()) {
            JpsElementChildRole role = (JpsElementChildRole)entry.getKey();
            JpsElement copy = ((JpsElement)entry.getValue()).getBulkModificationSupport().createCopy();
            JpsElementBase.setParent((JpsElement)copy, this.myParent);
            this.myElements.put(role, copy);
        }
    }

    public <T extends JpsElement> T getChild(JpsElementChildRole<T> role) {
        return (T)this.myElements.get(role);
    }

    public <T extends JpsElement, P, K extends JpsElementChildRole<T>> T setChild(K role, P param) {
        JpsElement child = ((JpsElementParameterizedCreator)role).create(param);
        return (T)this.setChild(role, child);
    }

    public <T extends JpsElement, K extends JpsElementChildRole<T>> T setChild(K role) {
        JpsElement child = ((JpsElementCreator)role).create();
        return (T)this.setChild(role, child);
    }

    public <T extends JpsElement, K extends JpsElementChildRole<T>> T getOrSetChild(K role) {
        T child = this.getChild(role);
        if (child == null) {
            return this.setChild(role);
        }
        return child;
    }

    public <T extends JpsElement> T setChild(JpsElementChildRole<T> role, T child) {
        this.myElements.put(role, child);
        JpsElementBase.setParent(child, this.myParent);
        JpsEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.fireElementAdded(child, role);
        }
        return child;
    }

    public <T extends JpsElement> void removeChild(JpsElementChildRole<T> role) {
        JpsElement removed = this.myElements.remove(role);
        if (removed == null) {
            return;
        }
        JpsEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.fireElementRemoved(removed, role);
        }
        JpsElementBase.setParent((JpsElement)removed, null);
    }

    protected Map<JpsElementChildRole<?>, JpsElement> getElementsMap() {
        return this.myElements;
    }

    public void applyChanges(JpsElementContainerEx modified) {
        for (JpsElementChildRole<?> jpsElementChildRole : this.myElements.keySet()) {
            this.applyChanges(jpsElementChildRole, modified);
        }
        for (JpsElementChildRole jpsElementChildRole : modified.getElementsMap().keySet()) {
            if (this.myElements.containsKey(jpsElementChildRole)) continue;
            this.applyChanges(jpsElementChildRole, modified);
        }
    }

    private <T extends JpsElement> void applyChanges(JpsElementChildRole<T> role, JpsElementContainerEx modified) {
        T child = this.getChild(role);
        JpsElement modifiedChild = modified.getChild(role);
        if (child != null && modifiedChild != null) {
            JpsElement.BulkModificationSupport modificationSupport = child.getBulkModificationSupport();
            modificationSupport.applyChanges(modifiedChild);
        } else if (modifiedChild == null) {
            this.removeChild(role);
        } else {
            this.setChild(role, modifiedChild.getBulkModificationSupport().createCopy());
        }
    }

    private JpsEventDispatcher getEventDispatcher() {
        return this.myParent.getEventDispatcher();
    }
}

