/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import com.intellij.openapi.util.Condition;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FilteringIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementCreator;
import org.jetbrains.jps.model.JpsElementType;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.JpsTypedElement;
import org.jetbrains.jps.model.ex.JpsElementBase;

public class JpsElementCollectionImpl<E extends JpsElement>
extends JpsElementBase<JpsElementCollectionImpl<E>>
implements JpsElementCollection<E> {
    private final List<E> myElements;
    private final Map<E, E> myCopyToOriginal;
    private final JpsElementChildRole<E> myChildRole;

    JpsElementCollectionImpl(JpsElementChildRole<E> role) {
        this.myChildRole = role;
        this.myElements = new SmartList();
        this.myCopyToOriginal = null;
    }

    private JpsElementCollectionImpl(JpsElementCollectionImpl<E> original) {
        this.myChildRole = original.myChildRole;
        this.myElements = new SmartList();
        this.myCopyToOriginal = new HashMap<E, E>();
        for (JpsElement e : original.myElements) {
            JpsElement copy = e.getBulkModificationSupport().createCopy();
            JpsElementCollectionImpl.setParent((JpsElement)copy, (JpsElementBase)this);
            this.myElements.add(copy);
            this.myCopyToOriginal.put(copy, e);
        }
    }

    public List<E> getElements() {
        return this.myElements;
    }

    public <X extends JpsTypedElement<P>, P extends JpsElement> Iterable<X> getElementsOfType(JpsElementType<P> type) {
        return new JpsElementIterable(type);
    }

    public E addChild(JpsElementCreator<E> creator) {
        return (E)this.addChild(creator.create());
    }

    public <X extends E> X addChild(X element) {
        this.myElements.add(element);
        JpsElementCollectionImpl.setParent(element, (JpsElementBase)this);
        JpsEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.fireElementAdded(element, this.myChildRole);
        }
        return element;
    }

    public void removeChild(E element) {
        boolean removed = this.myElements.remove(element);
        if (removed) {
            JpsEventDispatcher eventDispatcher = this.getEventDispatcher();
            if (eventDispatcher != null) {
                eventDispatcher.fireElementRemoved(element, this.myChildRole);
            }
            JpsElementCollectionImpl.setParent(element, null);
        }
    }

    public void removeAllChildren() {
        ArrayList<E> elements = new ArrayList<E>(this.myElements);
        for (JpsElement element : elements) {
            this.removeChild(element);
        }
    }

    public JpsElementCollectionImpl<E> createCopy() {
        return new JpsElementCollectionImpl<E>(this);
    }

    public void applyChanges(JpsElementCollectionImpl<E> modified) {
        LinkedHashSet<E> toRemove = new LinkedHashSet<E>(this.myElements);
        ArrayList<JpsElement> toAdd = new ArrayList<JpsElement>();
        Map<E, E> copyToOriginal = modified.myCopyToOriginal;
        for (JpsElement element : modified.myElements) {
            JpsElement original;
            JpsElement jpsElement = original = copyToOriginal != null ? (JpsElement)copyToOriginal.get(element) : null;
            if (original != null) {
                original.getBulkModificationSupport().applyChanges(element);
                toRemove.remove(original);
                continue;
            }
            JpsElement copy = element.getBulkModificationSupport().createCopy();
            toAdd.add(copy);
        }
        for (JpsElement e : toRemove) {
            this.removeChild(e);
        }
        for (JpsElement e : toAdd) {
            this.addChild(e);
        }
    }

    private class JpsElementIterable<X extends JpsTypedElement<P>, P extends JpsElement>
    implements Iterable<X> {
        private final JpsElementType<? extends JpsElement> myType;

        public JpsElementIterable(JpsElementType<P> type) {
            this.myType = type;
        }

        @Override
        public Iterator<X> iterator() {
            Iterator iterator = JpsElementCollectionImpl.this.myElements.iterator();
            return new FilteringIterator(iterator, new Condition<JpsTypedElement<?>>(){

                public boolean value(JpsTypedElement<?> e) {
                    return e.getType().equals(JpsElementIterable.this.myType);
                }
            });
        }
    }
}

