/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import java.util.Map;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsEncodingConfigurationService;
import org.jetbrains.jps.model.JpsEncodingProjectConfiguration;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.impl.JpsEncodingProjectConfigurationImpl;

public class JpsEncodingConfigurationServiceImpl
extends JpsEncodingConfigurationService {
    private static final JpsElementChildRoleBase<JpsSimpleElement<String>> ENCODING_ROLE = JpsElementChildRoleBase.create((String)"encoding");

    public String getGlobalEncoding(JpsGlobal global) {
        JpsSimpleElement encoding = (JpsSimpleElement)global.getContainer().getChild(ENCODING_ROLE);
        return encoding != null ? (String)encoding.getData() : null;
    }

    public void setGlobalEncoding(JpsGlobal global, String encoding) {
        if (encoding != null) {
            global.getContainer().setChild(ENCODING_ROLE, (JpsElement)JpsElementFactory.getInstance().createSimpleElement((Object)encoding));
        } else {
            global.getContainer().removeChild(ENCODING_ROLE);
        }
    }

    public String getProjectEncoding(JpsModel model) {
        String projectEncoding;
        JpsEncodingProjectConfiguration configuration = this.getEncodingConfiguration(model.getProject());
        if (configuration != null && (projectEncoding = configuration.getProjectEncoding()) != null) {
            return projectEncoding;
        }
        return this.getGlobalEncoding(model.getGlobal());
    }

    public JpsEncodingProjectConfiguration getEncodingConfiguration(JpsProject project) {
        return (JpsEncodingProjectConfiguration)project.getContainer().getChild(JpsEncodingProjectConfigurationImpl.ROLE);
    }

    public JpsEncodingProjectConfiguration setEncodingConfiguration(JpsProject project, String projectEncoding, Map<String, String> urlToEncoding) {
        JpsEncodingProjectConfigurationImpl configuration = new JpsEncodingProjectConfigurationImpl(urlToEncoding, projectEncoding);
        return (JpsEncodingProjectConfiguration)project.getContainer().setChild(JpsEncodingProjectConfigurationImpl.ROLE, (JpsElement)configuration);
    }
}

