/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsElementTypeWithDefaultProperties;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.JpsFileTypesConfiguration;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.impl.JpsFileTypesConfigurationImpl;
import org.jetbrains.jps.model.impl.JpsGlobalElementReference;
import org.jetbrains.jps.model.impl.JpsRootElementBase;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryCollectionImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRole;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;

public class JpsGlobalImpl
extends JpsRootElementBase<JpsGlobalImpl>
implements JpsGlobal {
    private final JpsLibraryCollectionImpl myLibraryCollection;

    public JpsGlobalImpl(JpsModel model, JpsEventDispatcher eventDispatcher) {
        super(model, eventDispatcher);
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection<JpsLibrary>)((JpsElementCollection)this.myContainer.setChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
        this.myContainer.setChild(JpsFileTypesConfigurationImpl.ROLE, (JpsElement)new JpsFileTypesConfigurationImpl());
    }

    public JpsGlobalImpl(JpsGlobalImpl original, JpsModel model, JpsEventDispatcher eventDispatcher) {
        super(original, model, eventDispatcher);
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection<JpsLibrary>)((JpsElementCollection)this.myContainer.getChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
    }

    public <P extends JpsElement, LibraryType extends JpsLibraryType<P> & JpsElementTypeWithDefaultProperties<P>> JpsLibrary addLibrary(LibraryType libraryType, String name) {
        return this.myLibraryCollection.addLibrary(name, libraryType);
    }

    public <P extends JpsElement> JpsTypedLibrary<JpsSdk<P>> addSdk(String name, String homePath, String versionString, JpsSdkType<P> type, P properties) {
        JpsTypedLibrary sdk = JpsElementFactory.getInstance().createSdk(name, homePath, versionString, type, properties);
        this.myLibraryCollection.addLibrary((JpsLibrary)sdk);
        return sdk;
    }

    public <P extends JpsElement, SdkType extends JpsSdkType<P>> JpsTypedLibrary<JpsSdk<P>> addSdk(String name, String homePath, String versionString, SdkType type) {
        return this.addSdk(name, homePath, versionString, type, (JpsElement)((JpsElementTypeWithDefaultProperties)type).createDefaultProperties());
    }

    public JpsLibraryCollection getLibraryCollection() {
        return this.myLibraryCollection;
    }

    public JpsFileTypesConfiguration getFileTypesConfiguration() {
        return (JpsFileTypesConfiguration)this.myContainer.getChild(JpsFileTypesConfigurationImpl.ROLE);
    }

    public JpsElementReference<JpsGlobal> createReference() {
        return new JpsGlobalElementReference();
    }
}

