/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import com.intellij.openapi.util.Comparing;
import java.util.List;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsElementTypeWithDefaultProperties;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.impl.JpsProjectElementReference;
import org.jetbrains.jps.model.impl.JpsRootElementBase;
import org.jetbrains.jps.model.impl.runConfiguration.JpsRunConfigurationImpl;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.impl.JpsLibraryCollectionImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRole;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.module.JpsSdkReferencesTable;
import org.jetbrains.jps.model.module.JpsTypedModule;
import org.jetbrains.jps.model.module.impl.JpsModuleImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleRole;
import org.jetbrains.jps.model.module.impl.JpsSdkReferencesTableImpl;
import org.jetbrains.jps.model.runConfiguration.JpsRunConfiguration;
import org.jetbrains.jps.model.runConfiguration.JpsRunConfigurationType;
import org.jetbrains.jps.model.runConfiguration.JpsTypedRunConfiguration;

public class JpsProjectImpl
extends JpsRootElementBase<JpsProjectImpl>
implements JpsProject {
    private static final JpsElementCollectionRole<JpsElementReference<?>> EXTERNAL_REFERENCES_COLLECTION_ROLE = JpsElementCollectionRole.create((JpsElementChildRole)JpsElementChildRoleBase.create((String)"external reference"));
    private static final JpsElementCollectionRole<JpsRunConfiguration> RUN_CONFIGURATIONS_ROLE = JpsElementCollectionRole.create((JpsElementChildRole)JpsElementChildRoleBase.create((String)"run configuration"));
    private final JpsLibraryCollection myLibraryCollection;
    private String myName = "";

    public JpsProjectImpl(JpsModel model, JpsEventDispatcher eventDispatcher) {
        super(model, eventDispatcher);
        this.myContainer.setChild(JpsModuleRole.MODULE_COLLECTION_ROLE);
        this.myContainer.setChild(EXTERNAL_REFERENCES_COLLECTION_ROLE);
        this.myContainer.setChild((JpsElementChildRole)JpsSdkReferencesTableImpl.ROLE);
        this.myContainer.setChild(RUN_CONFIGURATIONS_ROLE);
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection<JpsLibrary>)((JpsElementCollection)this.myContainer.setChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
    }

    public JpsProjectImpl(JpsProjectImpl original, JpsModel model, JpsEventDispatcher eventDispatcher) {
        super(original, model, eventDispatcher);
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection<JpsLibrary>)((JpsElementCollection)this.myContainer.getChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        if (!Comparing.equal((String)this.myName, (String)name)) {
            this.myName = name;
            this.fireElementChanged();
        }
    }

    public void addExternalReference(JpsElementReference<?> reference) {
        ((JpsElementCollection)this.myContainer.getChild(EXTERNAL_REFERENCES_COLLECTION_ROLE)).addChild(reference);
    }

    public <P extends JpsElement, ModuleType extends JpsModuleType<P> & JpsElementTypeWithDefaultProperties<P>> JpsModule addModule(String name, ModuleType moduleType) {
        JpsElementCollection collection = (JpsElementCollection)this.myContainer.getChild(JpsModuleRole.MODULE_COLLECTION_ROLE);
        return (JpsModule)collection.addChild(new JpsModuleImpl<JpsElement>((JpsModuleType<JpsElement>)moduleType, name, (JpsElement)((JpsElementTypeWithDefaultProperties<P>)moduleType).createDefaultProperties()));
    }

    public <P extends JpsElement, LibraryType extends JpsLibraryType<P> & JpsElementTypeWithDefaultProperties<P>> JpsLibrary addLibrary(String name, LibraryType libraryType) {
        return this.myLibraryCollection.addLibrary(name, libraryType);
    }

    public List<JpsModule> getModules() {
        return ((JpsElementCollection)this.myContainer.getChild(JpsModuleRole.MODULE_COLLECTION_ROLE)).getElements();
    }

    public <P extends JpsElement> Iterable<JpsTypedModule<P>> getModules(JpsModuleType<P> type) {
        return ((JpsElementCollection)this.myContainer.getChild(JpsModuleRole.MODULE_COLLECTION_ROLE)).getElementsOfType(type);
    }

    public void addModule(JpsModule module) {
        ((JpsElementCollection)this.myContainer.getChild(JpsModuleRole.MODULE_COLLECTION_ROLE)).addChild((JpsElement)module);
    }

    public JpsLibraryCollection getLibraryCollection() {
        return this.myLibraryCollection;
    }

    public JpsSdkReferencesTable getSdkReferencesTable() {
        return (JpsSdkReferencesTable)this.myContainer.getChild((JpsElementChildRole)JpsSdkReferencesTableImpl.ROLE);
    }

    public <P extends JpsElement> Iterable<JpsTypedRunConfiguration<P>> getRunConfigurations(JpsRunConfigurationType<P> type) {
        return this.getRunConfigurationsCollection().getElementsOfType(type);
    }

    public List<JpsRunConfiguration> getRunConfigurations() {
        return this.getRunConfigurationsCollection().getElements();
    }

    public <P extends JpsElement> JpsTypedRunConfiguration<P> addRunConfiguration(String name, JpsRunConfigurationType<P> type, P properties) {
        return (JpsTypedRunConfiguration)this.getRunConfigurationsCollection().addChild(new JpsRunConfigurationImpl<P>(name, type, properties));
    }

    private JpsElementCollection<JpsRunConfiguration> getRunConfigurationsCollection() {
        return (JpsElementCollection)this.myContainer.getChild(RUN_CONFIGURATIONS_ROLE);
    }

    public JpsElementReference<JpsProject> createReference() {
        return new JpsProjectElementReference();
    }
}

