/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Bitness;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.jps.service.SharedThreadPool;

public class JdkVersionDetectorImpl
extends JdkVersionDetector {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.SdkVersionUtil");
    private static final JdkVersionDetector.ActionRunner ACTION_RUNNER = new JdkVersionDetector.ActionRunner(){

        public Future<?> run(Runnable runnable) {
            return SharedThreadPool.getInstance().executeOnPooledThread(runnable);
        }
    };

    public String detectJdkVersion(String homePath) {
        return this.detectJdkVersion(homePath, ACTION_RUNNER);
    }

    public String detectJdkVersion(String homePath, JdkVersionDetector.ActionRunner actionRunner) {
        JdkVersionDetector.JdkVersionInfo info = this.detectJdkVersionInfo(homePath, actionRunner);
        if (info != null) {
            return info.getVersion();
        }
        return null;
    }

    public JdkVersionDetector.JdkVersionInfo detectJdkVersionInfo(String homePath) {
        return this.detectJdkVersionInfo(homePath, ACTION_RUNNER);
    }

    public JdkVersionDetector.JdkVersionInfo detectJdkVersionInfo(String homePath, JdkVersionDetector.ActionRunner actionRunner) {
        String[] command = new String[]{homePath + File.separator + "bin" + File.separator + "java", "-version"};
        return JdkVersionDetectorImpl.readVersionInfoFromProcessOutput(homePath, command, null, actionRunner);
    }

    public String readVersionFromProcessOutput(String homePath, String[] command, String versionLineMarker, JdkVersionDetector.ActionRunner actionRunner) {
        JdkVersionDetector.JdkVersionInfo info = JdkVersionDetectorImpl.readVersionInfoFromProcessOutput(homePath, command, versionLineMarker, actionRunner);
        if (info != null) {
            return info.getVersion();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JdkVersionDetector.JdkVersionInfo readVersionInfoFromProcessOutput(String homePath, String[] command, String versionLineMarker, JdkVersionDetector.ActionRunner actionRunner) {
        if (homePath == null || !new File(homePath).exists()) {
            return null;
        }
        try {
            Process process = Runtime.getRuntime().exec(command);
            VersionParsingThread parsingThread = new VersionParsingThread(process.getErrorStream(), versionLineMarker);
            Future parsingThreadFuture = actionRunner.run((Runnable)parsingThread);
            ReadStreamThread readThread = new ReadStreamThread(process.getInputStream());
            actionRunner.run((Runnable)readThread);
            try {
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    LOG.info((Throwable)e);
                    process.destroy();
                }
            }
            finally {
                try {
                    parsingThreadFuture.get();
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
            }
            String version = parsingThread.getVersion();
            if (version != null) {
                return new JdkVersionDetector.JdkVersionInfo(version, parsingThread.getBitness());
            }
        }
        catch (IOException ex) {
            LOG.info((Throwable)ex);
        }
        return null;
    }

    public static class VersionParsingThread
    implements Runnable {
        private Reader myReader;
        private final InputStream myStream;
        private boolean mySkipLF = false;
        private final String myVersionLineMarker;
        private final AtomicReference<String> myVersionString = new AtomicReference();
        private final AtomicReference<Bitness> myBitness = new AtomicReference<Bitness>(Bitness.x32);
        private static final String VERSION_LINE_MARKER = "version";
        private static final String BITNESS_64_MARKER = "64-Bit";

        protected VersionParsingThread(InputStream input, String versionLineMarker) {
            this.myStream = input;
            this.myVersionLineMarker = versionLineMarker != null ? versionLineMarker : VERSION_LINE_MARKER;
        }

        Bitness getBitness() {
            return this.myBitness.get();
        }

        String getVersion() {
            return this.myVersionString.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                this.myReader = new InputStreamReader(this.myStream);
                while (true) {
                    String line;
                    if ((line = this.readLine()) == null) {
                        return;
                    }
                    if (line.contains(this.myVersionLineMarker)) {
                        this.myVersionString.set(line);
                    }
                    if (!line.contains(BITNESS_64_MARKER)) continue;
                    this.myBitness.set(Bitness.x64);
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                return;
            }
            finally {
                if (this.myReader != null) {
                    try {
                        this.myReader.close();
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                    }
                }
            }
        }

        private String readLine() throws IOException {
            int c;
            boolean first = true;
            StringBuilder buffer = new StringBuilder();
            while ((c = this.myReader.read()) != -1) {
                first = false;
                if (c == 10) {
                    if (!this.mySkipLF) break;
                    this.mySkipLF = false;
                    continue;
                }
                if (c == 13) {
                    this.mySkipLF = true;
                    break;
                }
                this.mySkipLF = false;
                buffer.append((char)c);
            }
            if (first) {
                return null;
            }
            String s = buffer.toString();
            return s;
        }
    }

    public static class ReadStreamThread
    implements Runnable {
        private final InputStream myStream;

        protected ReadStreamThread(InputStream stream) {
            this.myStream = stream;
        }

        @Override
        public void run() {
            try {
                int b;
                while ((b = this.myStream.read()) != -1) {
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
    }
}

