/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.ExplodedDirectoryModuleExtension;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaDependencyExtension;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaModuleExtension;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.JpsJavaSdkTypeWrapper;
import org.jetbrains.jps.model.java.JpsProductionModuleOutputPackagingElement;
import org.jetbrains.jps.model.java.JpsTestModuleOutputPackagingElement;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.impl.ExplodedDirectoryModuleExtensionImpl;
import org.jetbrains.jps.model.java.impl.JavaModuleExtensionRole;
import org.jetbrains.jps.model.java.impl.JavaProjectExtensionRole;
import org.jetbrains.jps.model.java.impl.JavaSdkUtil;
import org.jetbrains.jps.model.java.impl.JpsJavaDependenciesEnumeratorImpl;
import org.jetbrains.jps.model.java.impl.JpsJavaDependencyExtensionRole;
import org.jetbrains.jps.model.java.impl.JpsProductionModuleOutputPackagingElementImpl;
import org.jetbrains.jps.model.java.impl.JpsTestModuleOutputPackagingElementImpl;
import org.jetbrains.jps.model.java.impl.JpsWrappedJavaSdkReferenceImpl;
import org.jetbrains.jps.model.java.impl.compiler.JpsJavaCompilerConfigurationImpl;
import org.jetbrains.jps.model.java.impl.runConfiguration.JpsApplicationRunConfigurationPropertiesImpl;
import org.jetbrains.jps.model.java.runConfiguration.JpsApplicationRunConfigurationProperties;
import org.jetbrains.jps.model.java.runConfiguration.JpsApplicationRunConfigurationState;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsJavaExtensionServiceImpl
extends JpsJavaExtensionService {
    public JpsJavaProjectExtension getOrCreateProjectExtension(JpsProject project) {
        return (JpsJavaProjectExtension)project.getContainer().getOrSetChild((JpsElementChildRole)JavaProjectExtensionRole.INSTANCE);
    }

    public JpsJavaProjectExtension getProjectExtension(JpsProject project) {
        return (JpsJavaProjectExtension)project.getContainer().getChild((JpsElementChildRole)JavaProjectExtensionRole.INSTANCE);
    }

    public JpsJavaModuleExtension getOrCreateModuleExtension(JpsModule module) {
        return (JpsJavaModuleExtension)module.getContainer().getOrSetChild((JpsElementChildRole)JavaModuleExtensionRole.INSTANCE);
    }

    public JpsJavaDependencyExtension getOrCreateDependencyExtension(JpsDependencyElement dependency) {
        return (JpsJavaDependencyExtension)dependency.getContainer().getOrSetChild((JpsElementChildRole)JpsJavaDependencyExtensionRole.INSTANCE);
    }

    public JpsJavaDependencyExtension getDependencyExtension(JpsDependencyElement dependency) {
        return (JpsJavaDependencyExtension)dependency.getContainer().getChild((JpsElementChildRole)JpsJavaDependencyExtensionRole.INSTANCE);
    }

    public JpsJavaModuleExtension getModuleExtension(JpsModule module) {
        return (JpsJavaModuleExtension)module.getContainer().getChild((JpsElementChildRole)JavaModuleExtensionRole.INSTANCE);
    }

    public ExplodedDirectoryModuleExtension getOrCreateExplodedDirectoryExtension(JpsModule module) {
        return (ExplodedDirectoryModuleExtension)module.getContainer().getOrSetChild((JpsElementChildRole)ExplodedDirectoryModuleExtensionImpl.ExplodedDirectoryModuleExtensionRole.INSTANCE);
    }

    public ExplodedDirectoryModuleExtension getExplodedDirectoryExtension(JpsModule module) {
        return (ExplodedDirectoryModuleExtension)module.getContainer().getChild((JpsElementChildRole)ExplodedDirectoryModuleExtensionImpl.ExplodedDirectoryModuleExtensionRole.INSTANCE);
    }

    public List<JpsDependencyElement> getDependencies(JpsModule module, JpsJavaClasspathKind classpathKind, boolean exportedOnly) {
        ArrayList<JpsDependencyElement> result = new ArrayList<JpsDependencyElement>();
        for (JpsDependencyElement dependencyElement : module.getDependenciesList().getDependencies()) {
            JpsJavaDependencyExtension extension = this.getDependencyExtension(dependencyElement);
            if (extension != null && (!extension.getScope().isIncludedIn(classpathKind) || exportedOnly && !extension.isExported())) continue;
            result.add(dependencyElement);
        }
        return result;
    }

    public LanguageLevel getLanguageLevel(JpsModule module) {
        JpsJavaModuleExtension moduleExtension = this.getModuleExtension(module);
        if (moduleExtension == null) {
            return null;
        }
        LanguageLevel languageLevel = moduleExtension.getLanguageLevel();
        if (languageLevel != null) {
            return languageLevel;
        }
        JpsJavaProjectExtension projectExtension = this.getProjectExtension(module.getProject());
        return projectExtension != null ? projectExtension.getLanguageLevel() : null;
    }

    public String getOutputUrl(JpsModule module, boolean forTests) {
        JpsJavaModuleExtension extension = this.getModuleExtension(module);
        if (extension == null) {
            return null;
        }
        if (extension.isInheritOutput()) {
            JpsJavaProjectExtension projectExtension = this.getProjectExtension(module.getProject());
            if (projectExtension == null) {
                return null;
            }
            String url = projectExtension.getOutputUrl();
            if (url == null) {
                return null;
            }
            return url + "/" + (forTests ? "test" : "production") + "/" + module.getName();
        }
        return forTests ? extension.getTestOutputUrl() : extension.getOutputUrl();
    }

    public File getOutputDirectory(JpsModule module, boolean forTests) {
        String url = this.getOutputUrl(module, forTests);
        return url != null ? JpsPathUtil.urlToFile((String)url) : null;
    }

    public JpsTypedLibrary<JpsSdk<JpsDummyElement>> addJavaSdk(JpsGlobal global, String name, String homePath) {
        String version = JdkVersionDetector.getInstance().detectJdkVersion(homePath);
        JpsTypedLibrary sdk = global.addSdk(name, homePath, version, (JpsSdkType)JpsJavaSdkType.INSTANCE);
        File homeDir = new File(FileUtil.toSystemDependentName((String)homePath));
        List<File> roots = JavaSdkUtil.getJdkClassesRoots(homeDir, false);
        for (File root : roots) {
            sdk.addRoot(root, JpsOrderRootType.COMPILED);
        }
        return sdk;
    }

    public JpsJavaCompilerConfiguration getCompilerConfiguration(JpsProject project) {
        return (JpsJavaCompilerConfiguration)project.getContainer().getChild(JpsJavaCompilerConfigurationImpl.ROLE);
    }

    public JpsJavaCompilerConfiguration getOrCreateCompilerConfiguration(JpsProject project) {
        JpsJavaCompilerConfiguration configuration = this.getCompilerConfiguration(project);
        if (configuration == null) {
            configuration = (JpsJavaCompilerConfiguration)project.getContainer().setChild(JpsJavaCompilerConfigurationImpl.ROLE, (JpsElement)new JpsJavaCompilerConfigurationImpl());
        }
        return configuration;
    }

    public JpsSdkReference<JpsDummyElement> createWrappedJavaSdkReference(JpsJavaSdkTypeWrapper sdkType, JpsSdkReference<?> wrapperReference) {
        return new JpsWrappedJavaSdkReferenceImpl(sdkType, wrapperReference);
    }

    public JpsApplicationRunConfigurationProperties createRunConfigurationProperties(JpsApplicationRunConfigurationState state) {
        return new JpsApplicationRunConfigurationPropertiesImpl(state);
    }

    public JavaSourceRootProperties createSourceRootProperties(String packagePrefix, boolean isGenerated) {
        return new JavaSourceRootProperties(packagePrefix, isGenerated);
    }

    public JavaSourceRootProperties createSourceRootProperties(String packagePrefix) {
        return this.createSourceRootProperties(packagePrefix, false);
    }

    public JavaResourceRootProperties createResourceRootProperties(String relativeOutputPath, boolean forGeneratedResource) {
        return new JavaResourceRootProperties(relativeOutputPath, forGeneratedResource);
    }

    public JpsProductionModuleOutputPackagingElement createProductionModuleOutput(JpsModuleReference moduleReference) {
        return new JpsProductionModuleOutputPackagingElementImpl(moduleReference);
    }

    public JpsTestModuleOutputPackagingElement createTestModuleOutput(JpsModuleReference moduleReference) {
        return new JpsTestModuleOutputPackagingElementImpl(moduleReference);
    }

    public JpsJavaDependenciesEnumerator enumerateDependencies(Collection<JpsModule> modules) {
        return new JpsJavaDependenciesEnumeratorImpl(modules);
    }

    protected JpsJavaDependenciesEnumerator enumerateDependencies(JpsProject project) {
        return new JpsJavaDependenciesEnumeratorImpl(project.getModules());
    }

    protected JpsJavaDependenciesEnumerator enumerateDependencies(JpsModule module) {
        return new JpsJavaDependenciesEnumeratorImpl(Collections.singletonList(module));
    }
}

