/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.java.impl.compiler.JpsCompilerExcludesImpl;
import org.jetbrains.jps.model.java.impl.compiler.ProcessorConfigProfileImpl;
import org.jetbrains.jps.model.java.impl.compiler.ResourcePatterns;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsJavaCompilerConfigurationImpl
extends JpsCompositeElementBase<JpsJavaCompilerConfigurationImpl>
implements JpsJavaCompilerConfiguration {
    public static final JpsElementChildRole<JpsJavaCompilerConfiguration> ROLE = JpsElementChildRoleBase.create((String)"compiler configuration");
    private boolean myAddNotNullAssertions = true;
    private boolean myClearOutputDirectoryOnRebuild = true;
    private final JpsCompilerExcludes myCompilerExcludes = new JpsCompilerExcludesImpl();
    private final List<String> myResourcePatterns = new ArrayList<String>();
    private final List<ProcessorConfigProfile> myAnnotationProcessingProfiles = new ArrayList<ProcessorConfigProfile>();
    private final ProcessorConfigProfileImpl myDefaultAnnotationProcessingProfile = new ProcessorConfigProfileImpl("Default");
    private String myProjectByteCodeTargetLevel;
    private final Map<String, String> myModulesByteCodeTargetLevels = new HashMap<String, String>();
    private final Map<String, JpsJavaCompilerOptions> myCompilerOptions = new HashMap<String, JpsJavaCompilerOptions>();
    private String myJavaCompilerId = "Javac";
    private Map<JpsModule, ProcessorConfigProfile> myAnnotationProcessingProfileMap;
    private ResourcePatterns myCompiledPatterns;

    public JpsJavaCompilerConfigurationImpl() {
    }

    private JpsJavaCompilerConfigurationImpl(JpsJavaCompilerConfigurationImpl original) {
        super((JpsCompositeElementBase)original);
    }

    public JpsJavaCompilerConfigurationImpl createCopy() {
        return new JpsJavaCompilerConfigurationImpl(this);
    }

    public boolean isAddNotNullAssertions() {
        return this.myAddNotNullAssertions;
    }

    public boolean isClearOutputDirectoryOnRebuild() {
        return this.myClearOutputDirectoryOnRebuild;
    }

    public void setAddNotNullAssertions(boolean addNotNullAssertions) {
        this.myAddNotNullAssertions = addNotNullAssertions;
    }

    public void setClearOutputDirectoryOnRebuild(boolean clearOutputDirectoryOnRebuild) {
        this.myClearOutputDirectoryOnRebuild = clearOutputDirectoryOnRebuild;
    }

    public JpsCompilerExcludes getCompilerExcludes() {
        return this.myCompilerExcludes;
    }

    public ProcessorConfigProfile getDefaultAnnotationProcessingProfile() {
        return this.myDefaultAnnotationProcessingProfile;
    }

    public Collection<ProcessorConfigProfile> getAnnotationProcessingProfiles() {
        return this.myAnnotationProcessingProfiles;
    }

    public void addResourcePattern(String pattern) {
        this.myResourcePatterns.add(pattern);
    }

    public List<String> getResourcePatterns() {
        return this.myResourcePatterns;
    }

    public boolean isResourceFile(File file, File srcRoot) {
        ResourcePatterns patterns = this.myCompiledPatterns;
        if (patterns == null) {
            this.myCompiledPatterns = patterns = new ResourcePatterns(this);
        }
        return patterns.isResourceFile(file, srcRoot);
    }

    public String getByteCodeTargetLevel(String moduleName) {
        String level = this.myModulesByteCodeTargetLevels.get(moduleName);
        if (level != null) {
            return level.isEmpty() ? null : level;
        }
        return this.myProjectByteCodeTargetLevel;
    }

    public void setModuleByteCodeTargetLevel(String moduleName, String level) {
        this.myModulesByteCodeTargetLevels.put(moduleName, level);
    }

    public String getJavaCompilerId() {
        return this.myJavaCompilerId;
    }

    public void setJavaCompilerId(String compiler) {
        this.myJavaCompilerId = compiler;
    }

    public JpsJavaCompilerOptions getCompilerOptions(String compilerId) {
        JpsJavaCompilerOptions options = this.myCompilerOptions.get(compilerId);
        if (options == null) {
            options = new JpsJavaCompilerOptions();
            this.myCompilerOptions.put(compilerId, options);
        }
        return options;
    }

    public void setCompilerOptions(String compilerId, JpsJavaCompilerOptions options) {
        this.myCompilerOptions.put(compilerId, options);
    }

    public JpsJavaCompilerOptions getCurrentCompilerOptions() {
        return this.getCompilerOptions(this.getJavaCompilerId());
    }

    public void setProjectByteCodeTargetLevel(String level) {
        this.myProjectByteCodeTargetLevel = level;
    }

    public ProcessorConfigProfile addAnnotationProcessingProfile() {
        ProcessorConfigProfileImpl profile = new ProcessorConfigProfileImpl("");
        this.myAnnotationProcessingProfiles.add(profile);
        return profile;
    }

    public ProcessorConfigProfile getAnnotationProcessingProfile(JpsModule module) {
        ProcessorConfigProfile profile;
        Map<JpsModule, ProcessorConfigProfile> map = this.myAnnotationProcessingProfileMap;
        if (map == null) {
            map = new HashMap<JpsModule, ProcessorConfigProfile>();
            HashMap<String, JpsModule> namesMap = new HashMap<String, JpsModule>();
            for (JpsModule m : module.getProject().getModules()) {
                namesMap.put(m.getName(), m);
            }
            if (!namesMap.isEmpty()) {
                for (ProcessorConfigProfile profile2 : this.getAnnotationProcessingProfiles()) {
                    for (String name : profile2.getModuleNames()) {
                        JpsModule mod = (JpsModule)namesMap.get(name);
                        if (mod == null) continue;
                        map.put(mod, profile2);
                    }
                }
            }
            this.myAnnotationProcessingProfileMap = map;
        }
        return (profile = map.get(module)) != null ? profile : this.getDefaultAnnotationProcessingProfile();
    }
}

