/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl.compiler;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;

public final class ProcessorConfigProfileImpl
implements ProcessorConfigProfile {
    private String myName = "";
    private boolean myEnabled = false;
    private boolean myObtainProcessorsFromClasspath = true;
    private String myProcessorPath = "";
    private final Set<String> myProcessors = new THashSet(1);
    private final Map<String, String> myProcessorOptions = new THashMap(1);
    private String myGeneratedProductionDirectoryName = "generated";
    private String myGeneratedTestsDirectoryName = "generated_tests";
    private boolean myOutputRelativeToContentRoot = false;
    private final Set<String> myModuleNames = new THashSet(1);

    public ProcessorConfigProfileImpl(String name) {
        this.myName = name;
    }

    public ProcessorConfigProfileImpl(ProcessorConfigProfile profile) {
        this.initFrom(profile);
    }

    public final void initFrom(ProcessorConfigProfile other) {
        this.myName = other.getName();
        this.myEnabled = other.isEnabled();
        this.myObtainProcessorsFromClasspath = other.isObtainProcessorsFromClasspath();
        this.myProcessorPath = other.getProcessorPath();
        this.myProcessors.clear();
        this.myProcessors.addAll(other.getProcessors());
        this.myProcessorOptions.clear();
        this.myProcessorOptions.putAll(other.getProcessorOptions());
        this.myGeneratedProductionDirectoryName = other.getGeneratedSourcesDirectoryName(false);
        this.myGeneratedTestsDirectoryName = other.getGeneratedSourcesDirectoryName(true);
        this.myOutputRelativeToContentRoot = other.isOutputRelativeToContentRoot();
        this.myModuleNames.clear();
        this.myModuleNames.addAll(other.getModuleNames());
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public String getProcessorPath() {
        return this.myProcessorPath;
    }

    public void setProcessorPath(String processorPath) {
        this.myProcessorPath = processorPath != null ? processorPath : "";
    }

    public boolean isObtainProcessorsFromClasspath() {
        return this.myObtainProcessorsFromClasspath;
    }

    public void setObtainProcessorsFromClasspath(boolean value) {
        this.myObtainProcessorsFromClasspath = value;
    }

    public String getGeneratedSourcesDirectoryName(boolean forTests) {
        return forTests ? this.myGeneratedTestsDirectoryName : this.myGeneratedProductionDirectoryName;
    }

    public void setGeneratedSourcesDirectoryName(String name, boolean forTests) {
        if (forTests) {
            this.myGeneratedTestsDirectoryName = name != null ? name.trim() : "generated_tests";
        } else {
            this.myGeneratedProductionDirectoryName = name != null ? name.trim() : "generated";
        }
    }

    public boolean isOutputRelativeToContentRoot() {
        return this.myOutputRelativeToContentRoot;
    }

    public void setOutputRelativeToContentRoot(boolean relativeToContent) {
        this.myOutputRelativeToContentRoot = relativeToContent;
    }

    public Set<String> getModuleNames() {
        return this.myModuleNames;
    }

    public boolean addModuleName(String name) {
        return this.myModuleNames.add(name);
    }

    public boolean addModuleNames(Collection<String> names) {
        return this.myModuleNames.addAll(names);
    }

    public boolean removeModuleName(String name) {
        return this.myModuleNames.remove(name);
    }

    public boolean removeModuleNames(Collection<String> names) {
        return this.myModuleNames.removeAll(names);
    }

    public void clearModuleNames() {
        this.myModuleNames.clear();
    }

    public void clearProcessors() {
        this.myProcessors.clear();
    }

    public boolean addProcessor(String processor) {
        return this.myProcessors.add(processor);
    }

    public boolean removeProcessor(String processor) {
        return this.myProcessors.remove(processor);
    }

    public Set<String> getProcessors() {
        return Collections.unmodifiableSet(this.myProcessors);
    }

    public Map<String, String> getProcessorOptions() {
        return Collections.unmodifiableMap(this.myProcessorOptions);
    }

    public String setOption(String key, String value) {
        return this.myProcessorOptions.put(key, value);
    }

    public String getOption(String key) {
        return this.myProcessorOptions.get(key);
    }

    public void clearProcessorOptions() {
        this.myProcessorOptions.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorConfigProfileImpl profile = (ProcessorConfigProfileImpl)o;
        if (this.myEnabled != profile.myEnabled) {
            return false;
        }
        if (this.myObtainProcessorsFromClasspath != profile.myObtainProcessorsFromClasspath) {
            return false;
        }
        if (this.myGeneratedProductionDirectoryName != null ? !this.myGeneratedProductionDirectoryName.equals(profile.myGeneratedProductionDirectoryName) : profile.myGeneratedProductionDirectoryName != null) {
            return false;
        }
        if (this.myGeneratedTestsDirectoryName != null ? !this.myGeneratedTestsDirectoryName.equals(profile.myGeneratedTestsDirectoryName) : profile.myGeneratedTestsDirectoryName != null) {
            return false;
        }
        if (this.myOutputRelativeToContentRoot != profile.myOutputRelativeToContentRoot) {
            return false;
        }
        if (!((Object)this.myModuleNames).equals(profile.myModuleNames)) {
            return false;
        }
        if (!((Object)this.myProcessorOptions).equals(profile.myProcessorOptions)) {
            return false;
        }
        if (this.myProcessorPath != null ? !this.myProcessorPath.equals(profile.myProcessorPath) : profile.myProcessorPath != null) {
            return false;
        }
        if (!((Object)this.myProcessors).equals(profile.myProcessors)) {
            return false;
        }
        return this.myName.equals(profile.myName);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + (this.myEnabled ? 1 : 0);
        result = 31 * result + (this.myObtainProcessorsFromClasspath ? 1 : 0);
        result = 31 * result + (this.myProcessorPath != null ? this.myProcessorPath.hashCode() : 0);
        result = 31 * result + ((Object)this.myProcessors).hashCode();
        result = 31 * result + ((Object)this.myProcessorOptions).hashCode();
        result = 31 * result + (this.myGeneratedProductionDirectoryName != null ? this.myGeneratedProductionDirectoryName.hashCode() : 0);
        result = 31 * result + (this.myGeneratedTestsDirectoryName != null ? this.myGeneratedTestsDirectoryName.hashCode() : 0);
        result = 31 * result + (this.myOutputRelativeToContentRoot ? 1 : 0);
        result = 31 * result + ((Object)this.myModuleNames).hashCode();
        return result;
    }

    public String toString() {
        return this.myName;
    }
}

