/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsReferenceableElement;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;
import org.jetbrains.jps.model.impl.JpsElementCollectionImpl;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryReference;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryReferenceImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRootImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRootRole;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsLibraryImpl<P extends JpsElement>
extends JpsNamedCompositeElementBase<JpsLibraryImpl<P>>
implements JpsTypedLibrary<P> {
    private final JpsLibraryType<P> myLibraryType;
    private static final Set<String> AR_EXTENSIONS = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY, (Object[])new String[]{"jar", "zip", "swc", "ane"});

    public JpsLibraryImpl(String name, JpsLibraryType<P> type, P properties) {
        super(name);
        this.myLibraryType = type;
        this.myContainer.setChild(this.myLibraryType.getPropertiesRole(), properties);
    }

    private JpsLibraryImpl(JpsLibraryImpl<P> original) {
        super(original);
        this.myLibraryType = original.myLibraryType;
    }

    public JpsLibraryType<P> getType() {
        return this.myLibraryType;
    }

    public <P extends JpsElement> JpsTypedLibrary<P> asTyped(JpsLibraryType<P> type) {
        return this.myLibraryType.equals(type) ? this : null;
    }

    public P getProperties() {
        return (P)this.myContainer.getChild(this.myLibraryType.getPropertiesRole());
    }

    public List<JpsLibraryRoot> getRoots(JpsOrderRootType rootType) {
        JpsElementCollection rootsCollection = (JpsElementCollection)this.myContainer.getChild(JpsLibraryImpl.getRole(rootType));
        return rootsCollection != null ? rootsCollection.getElements() : Collections.emptyList();
    }

    public void addRoot(String url, JpsOrderRootType rootType) {
        this.addRoot(url, rootType, JpsLibraryRoot.InclusionOptions.ROOT_ITSELF);
    }

    public void addRoot(File file, JpsOrderRootType rootType) {
        this.addRoot(JpsPathUtil.getLibraryRootUrl((File)file), rootType);
    }

    public void addRoot(String url, JpsOrderRootType rootType, JpsLibraryRoot.InclusionOptions options) {
        ((JpsElementCollection)this.myContainer.getOrSetChild(JpsLibraryImpl.getRole(rootType))).addChild((JpsElement)new JpsLibraryRootImpl(url, rootType, options));
    }

    public void removeUrl(String url, JpsOrderRootType rootType) {
        JpsElementCollection rootsCollection = (JpsElementCollection)this.myContainer.getChild(JpsLibraryImpl.getRole(rootType));
        if (rootsCollection != null) {
            for (JpsLibraryRoot root : rootsCollection.getElements()) {
                if (!root.getUrl().equals(url) || !root.getRootType().equals(rootType)) continue;
                rootsCollection.removeChild((JpsElement)root);
                break;
            }
        }
    }

    private static JpsElementCollectionRole<JpsLibraryRoot> getRole(JpsOrderRootType type) {
        return JpsElementCollectionRole.create((JpsElementChildRole)new JpsLibraryRootRole(type));
    }

    public void delete() {
        this.getParent().removeChild(this);
    }

    public JpsElementCollectionImpl<JpsLibrary> getParent() {
        return (JpsElementCollectionImpl)this.myParent;
    }

    public JpsLibraryImpl<P> createCopy() {
        return new JpsLibraryImpl<P>(this);
    }

    public JpsLibraryReference createReference() {
        return new JpsLibraryReferenceImpl(this.getName(), this.createParentReference());
    }

    private JpsElementReference<JpsCompositeElement> createParentReference() {
        return ((JpsReferenceableElement)this.getParent().getParent()).createReference();
    }

    public List<File> getFiles(JpsOrderRootType rootType) {
        List<String> urls = this.getRootUrls(rootType);
        ArrayList<File> files = new ArrayList<File>(urls.size());
        for (String url : urls) {
            if (url.startsWith("jrt://")) continue;
            files.add(JpsPathUtil.urlToFile((String)url));
        }
        return files;
    }

    public List<String> getRootUrls(JpsOrderRootType rootType) {
        ArrayList<String> urls = new ArrayList<String>();
        for (JpsLibraryRoot root : this.getRoots(rootType)) {
            switch (root.getInclusionOptions()) {
                case ROOT_ITSELF: {
                    urls.add(root.getUrl());
                    break;
                }
                case ARCHIVES_UNDER_ROOT: {
                    JpsLibraryImpl.collectArchives(JpsPathUtil.urlToFile((String)root.getUrl()), false, urls);
                    break;
                }
                case ARCHIVES_UNDER_ROOT_RECURSIVELY: {
                    JpsLibraryImpl.collectArchives(JpsPathUtil.urlToFile((String)root.getUrl()), true, urls);
                }
            }
        }
        return urls;
    }

    private static void collectArchives(File file, boolean recursively, List<String> result) {
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                String extension = FileUtilRt.getExtension((String)child.getName());
                if (child.isDirectory()) {
                    if (!recursively) continue;
                    JpsLibraryImpl.collectArchives(child, recursively, result);
                    continue;
                }
                if (!AR_EXTENSIONS.contains(extension)) continue;
                result.add(JpsPathUtil.getLibraryRootUrl((File)child));
            }
        }
    }
}

