/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import com.intellij.openapi.util.Condition;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.module.JpsDependenciesEnumerator;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.jps.model.module.JpsModuleSourceDependency;
import org.jetbrains.jps.model.module.JpsSdkDependency;

public abstract class JpsDependenciesEnumeratorBase<Self extends JpsDependenciesEnumerator>
implements JpsDependenciesEnumerator {
    private boolean myWithoutSdk;
    private boolean myWithoutLibraries;
    protected boolean myWithoutDepModules;
    private boolean myWithoutModuleSourceEntries;
    protected boolean myRecursively;
    protected final Collection<JpsModule> myRootModules;
    private Condition<JpsDependencyElement> myCondition;

    protected JpsDependenciesEnumeratorBase(Collection<JpsModule> rootModules) {
        this.myRootModules = rootModules;
    }

    public Self withoutLibraries() {
        this.myWithoutLibraries = true;
        return this.self();
    }

    public Self withoutDepModules() {
        this.myWithoutDepModules = true;
        return this.self();
    }

    public Self withoutSdk() {
        this.myWithoutSdk = true;
        return this.self();
    }

    public Self withoutModuleSourceEntries() {
        this.myWithoutModuleSourceEntries = true;
        return this.self();
    }

    public Self satisfying(Condition<JpsDependencyElement> condition) {
        this.myCondition = condition;
        return this.self();
    }

    public Self recursively() {
        this.myRecursively = true;
        return this.self();
    }

    protected abstract Self self();

    public Set<JpsModule> getModules() {
        LinkedHashSet<JpsModule> result = new LinkedHashSet<JpsModule>();
        this.processModules((Consumer<JpsModule>)new CollectConsumer(result));
        return result;
    }

    public void processModules(Consumer<JpsModule> consumer) {
        this.processModuleAndLibraries(consumer, (Consumer<JpsLibrary>)Consumer.EMPTY_CONSUMER);
    }

    protected boolean shouldProcessDependenciesRecursively() {
        return true;
    }

    public boolean processDependencies(Processor<JpsDependencyElement> processor) {
        THashSet processed = new THashSet();
        for (JpsModule module : this.myRootModules) {
            if (this.doProcessDependencies(module, processor, (Set<JpsModule>)processed)) continue;
            return false;
        }
        return true;
    }

    private boolean doProcessDependencies(JpsModule module, Processor<JpsDependencyElement> processor, Set<JpsModule> processed) {
        if (!processed.add(module)) {
            return true;
        }
        for (JpsDependencyElement element : module.getDependenciesList().getDependencies()) {
            if (this.myCondition != null && !this.myCondition.value((Object)element) || this.myWithoutSdk && element instanceof JpsSdkDependency || this.myWithoutLibraries && element instanceof JpsLibraryDependency || this.myWithoutModuleSourceEntries && element instanceof JpsModuleSourceDependency || this.myWithoutDepModules && (!this.myRecursively && element instanceof JpsModuleDependency || element instanceof JpsModuleSourceDependency && !this.isEnumerationRootModule(module)) || !this.shouldProcess(module, element)) continue;
            if (element instanceof JpsModuleDependency) {
                JpsModule depModule;
                if (this.myRecursively && this.shouldProcessDependenciesRecursively() && (depModule = ((JpsModuleDependency)element).getModule()) != null) {
                    this.doProcessDependencies(depModule, processor, processed);
                    continue;
                }
                if (this.myWithoutDepModules) continue;
            }
            if (processor.process((Object)element)) continue;
            return false;
        }
        return true;
    }

    protected boolean shouldProcess(JpsModule module, JpsDependencyElement element) {
        return true;
    }

    public boolean isEnumerationRootModule(JpsModule module) {
        return this.myRootModules.contains(module);
    }

    public Set<JpsLibrary> getLibraries() {
        LinkedHashSet<JpsLibrary> libraries = new LinkedHashSet<JpsLibrary>();
        this.processLibraries((Consumer<JpsLibrary>)new CollectConsumer(libraries));
        return libraries;
    }

    public void processLibraries(Consumer<JpsLibrary> consumer) {
        this.processModuleAndLibraries((Consumer<JpsModule>)Consumer.EMPTY_CONSUMER, consumer);
    }

    public void processModuleAndLibraries(final Consumer<JpsModule> moduleConsumer, final Consumer<JpsLibrary> libraryConsumer) {
        this.processDependencies(new Processor<JpsDependencyElement>(){

            public boolean process(JpsDependencyElement dependencyElement) {
                JpsLibrary library;
                if (moduleConsumer != null) {
                    JpsModule module;
                    if (JpsDependenciesEnumeratorBase.this.myRecursively && dependencyElement instanceof JpsModuleSourceDependency) {
                        moduleConsumer.consume((Object)dependencyElement.getContainingModule());
                    } else if (!(JpsDependenciesEnumeratorBase.this.myRecursively && JpsDependenciesEnumeratorBase.this.shouldProcessDependenciesRecursively() || !(dependencyElement instanceof JpsModuleDependency) || (module = ((JpsModuleDependency)dependencyElement).getModule()) == null)) {
                        moduleConsumer.consume((Object)module);
                    }
                }
                if (libraryConsumer != null && dependencyElement instanceof JpsLibraryDependency && (library = ((JpsLibraryDependency)dependencyElement).getLibrary()) != null) {
                    libraryConsumer.consume((Object)library);
                }
                return true;
            }
        });
    }
}

