/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import java.util.List;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementType;
import org.jetbrains.jps.model.JpsElementTypeWithDefaultProperties;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsUrlList;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;
import org.jetbrains.jps.model.impl.JpsUrlListRole;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryCollectionImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRole;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependenciesList;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.module.JpsSdkReferencesTable;
import org.jetbrains.jps.model.module.JpsTypedModule;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.model.module.impl.JpsDependenciesListImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleReferenceImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleSourceRootImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleSourceRootRole;
import org.jetbrains.jps.model.module.impl.JpsSdkReferencesTableImpl;

public class JpsModuleImpl<P extends JpsElement>
extends JpsNamedCompositeElementBase<JpsModuleImpl<P>>
implements JpsTypedModule<P> {
    private static final JpsUrlListRole CONTENT_ROOTS_ROLE = new JpsUrlListRole("content roots");
    private static final JpsUrlListRole EXCLUDED_ROOTS_ROLE = new JpsUrlListRole("excluded roots");
    private static final JpsElementChildRole<JpsDependenciesListImpl> DEPENDENCIES_LIST_CHILD_ROLE = JpsElementChildRoleBase.create((String)"dependencies");
    private final JpsModuleType<P> myModuleType;
    private final JpsLibraryCollection myLibraryCollection;

    public JpsModuleImpl(JpsModuleType<P> type, String name, P properties) {
        super(name);
        this.myModuleType = type;
        this.myContainer.setChild(this.myModuleType.getPropertiesRole(), properties);
        this.myContainer.setChild((JpsElementChildRole)CONTENT_ROOTS_ROLE);
        this.myContainer.setChild((JpsElementChildRole)EXCLUDED_ROOTS_ROLE);
        this.myContainer.setChild(DEPENDENCIES_LIST_CHILD_ROLE, (JpsElement)new JpsDependenciesListImpl());
        this.getDependenciesList().addModuleSourceDependency();
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection<JpsLibrary>)((JpsElementCollection)this.myContainer.setChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
        this.myContainer.setChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE);
        this.myContainer.setChild((JpsElementChildRole)JpsSdkReferencesTableImpl.ROLE);
    }

    private JpsModuleImpl(JpsModuleImpl<P> original) {
        super(original);
        this.myModuleType = original.myModuleType;
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection<JpsLibrary>)((JpsElementCollection)this.myContainer.getChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
    }

    public JpsModuleImpl<P> createCopy() {
        return new JpsModuleImpl<P>(this);
    }

    public JpsElementType<P> getType() {
        return this.myModuleType;
    }

    public P getProperties() {
        return (P)this.myContainer.getChild(this.myModuleType.getPropertiesRole());
    }

    public <P extends JpsElement> JpsTypedModule<P> asTyped(JpsModuleType<P> type) {
        return this.myModuleType.equals(type) ? this : null;
    }

    public JpsUrlList getContentRootsList() {
        return (JpsUrlList)this.myContainer.getChild((JpsElementChildRole)CONTENT_ROOTS_ROLE);
    }

    public JpsUrlList getExcludeRootsList() {
        return (JpsUrlList)this.myContainer.getChild((JpsElementChildRole)EXCLUDED_ROOTS_ROLE);
    }

    public List<JpsModuleSourceRoot> getSourceRoots() {
        return ((JpsElementCollection)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE)).getElements();
    }

    public <P extends JpsElement> Iterable<JpsTypedModuleSourceRoot<P>> getSourceRoots(JpsModuleSourceRootType<P> type) {
        return ((JpsElementCollection)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE)).getElementsOfType(type);
    }

    public <P extends JpsElement> JpsModuleSourceRoot addSourceRoot(String url, JpsModuleSourceRootType<P> rootType) {
        return this.addSourceRoot(url, rootType, (JpsElement)rootType.createDefaultProperties());
    }

    public <P extends JpsElement> JpsModuleSourceRoot addSourceRoot(String url, JpsModuleSourceRootType<P> rootType, P properties) {
        JpsModuleSourceRootImpl<P> root = new JpsModuleSourceRootImpl<P>(url, rootType, properties);
        this.addSourceRoot((JpsModuleSourceRoot)root);
        return root;
    }

    public void addSourceRoot(JpsModuleSourceRoot root) {
        ((JpsElementCollection)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE)).addChild((JpsElement)root);
    }

    public void removeSourceRoot(String url, JpsModuleSourceRootType rootType) {
        JpsElementCollection roots = (JpsElementCollection)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE);
        for (JpsModuleSourceRoot root : roots.getElements()) {
            if (!root.getRootType().equals(rootType) || !root.getUrl().equals(url)) continue;
            roots.removeChild((JpsElement)root);
            break;
        }
    }

    public JpsDependenciesList getDependenciesList() {
        return (JpsDependenciesList)this.myContainer.getChild(DEPENDENCIES_LIST_CHILD_ROLE);
    }

    public JpsSdkReferencesTable getSdkReferencesTable() {
        return (JpsSdkReferencesTable)this.myContainer.getChild((JpsElementChildRole)JpsSdkReferencesTableImpl.ROLE);
    }

    public <P extends JpsElement> JpsSdkReference<P> getSdkReference(JpsSdkType<P> type) {
        JpsSdkReference sdkReference = this.getSdkReferencesTable().getSdkReference(type);
        if (sdkReference != null) {
            return sdkReference;
        }
        JpsProject project = this.getProject();
        if (project != null) {
            return project.getSdkReferencesTable().getSdkReference(type);
        }
        return null;
    }

    public <P extends JpsElement> JpsSdk<P> getSdk(JpsSdkType<P> type) {
        JpsSdkReference<P> reference = this.getSdkReference(type);
        if (reference == null) {
            return null;
        }
        JpsTypedLibrary library = (JpsTypedLibrary)reference.resolve();
        return library != null ? (JpsSdk)library.getProperties() : null;
    }

    public void delete() {
        ((JpsElementCollection)this.myParent).removeChild((JpsElement)this);
    }

    public JpsModuleReference createReference() {
        return new JpsModuleReferenceImpl(this.getName());
    }

    public <P extends JpsElement, Type extends JpsLibraryType<P> & JpsElementTypeWithDefaultProperties<P>> JpsLibrary addModuleLibrary(String name, Type type) {
        return this.myLibraryCollection.addLibrary(name, type);
    }

    public void addModuleLibrary(JpsLibrary library) {
        this.myLibraryCollection.addLibrary(library);
    }

    public JpsLibraryCollection getLibraryCollection() {
        return this.myLibraryCollection;
    }

    public JpsProject getProject() {
        JpsModel model = this.getModel();
        return model != null ? model.getProject() : null;
    }

    public JpsModuleType<P> getModuleType() {
        return this.myModuleType;
    }
}

