/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class PathMacroUtil {
    @NonNls
    public static final String PROJECT_DIR_MACRO_NAME = "PROJECT_DIR";
    @NonNls
    public static final String MODULE_DIR_MACRO_NAME = "MODULE_DIR";
    @NonNls
    public static final String DIRECTORY_STORE_NAME = ".idea";
    @NonNls
    public static final String APPLICATION_HOME_DIR = "APPLICATION_HOME_DIR";
    @NonNls
    public static final String APPLICATION_CONFIG_DIR = "APPLICATION_CONFIG_DIR";
    @NonNls
    public static final String APPLICATION_PLUGINS_DIR = "APPLICATION_PLUGINS_DIR";
    @NonNls
    public static final String USER_HOME_NAME = "USER_HOME";
    private static final Map<String, String> ourGlobalMacros = ContainerUtil.immutableMapBuilder().put((Object)"APPLICATION_HOME_DIR", (Object)FileUtil.toSystemIndependentName((String)PathManager.getHomePath())).put((Object)"APPLICATION_CONFIG_DIR", (Object)FileUtil.toSystemIndependentName((String)PathManager.getConfigPath())).put((Object)"APPLICATION_PLUGINS_DIR", (Object)FileUtil.toSystemIndependentName((String)PathManager.getPluginsPath())).put((Object)"USER_HOME", (Object)StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)SystemProperties.getUserHome()), (String)"/")).build();

    public static String getModuleDir(String moduleFilePath) {
        File moduleDirFile = new File(moduleFilePath).getParentFile();
        if (moduleDirFile == null) {
            return null;
        }
        File moduleDirParent = moduleDirFile.getParentFile();
        if (moduleDirParent != null && moduleDirFile.getName().equals(DIRECTORY_STORE_NAME)) {
            moduleDirFile = moduleDirParent;
        }
        String moduleDir = moduleDirFile.getPath();
        if ((moduleDir = moduleDir.replace(File.separatorChar, '/')).endsWith(":/")) {
            moduleDir = moduleDir.substring(0, moduleDir.length() - 1);
        }
        return moduleDir;
    }

    public static String getUserHomePath() {
        return (String)ObjectUtils.assertNotNull((Object)PathMacroUtil.getGlobalSystemMacroValue(USER_HOME_NAME));
    }

    public static Map<String, String> getGlobalSystemMacros() {
        return ourGlobalMacros;
    }

    public static String getGlobalSystemMacroValue(String name) {
        return ourGlobalMacros.get(name);
    }
}

