/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.serialization.JpsPathVariablesConfiguration;

public class JpsPathVariablesConfigurationImpl
extends JpsElementBase<JpsPathVariablesConfigurationImpl>
implements JpsPathVariablesConfiguration {
    private Map<String, String> myPathVariables;

    public JpsPathVariablesConfigurationImpl() {
        this.myPathVariables = new LinkedHashMap<String, String>();
    }

    private JpsPathVariablesConfigurationImpl(Map<String, String> pathVariables) {
        this.myPathVariables = new LinkedHashMap<String, String>(pathVariables);
    }

    public JpsPathVariablesConfigurationImpl createCopy() {
        return new JpsPathVariablesConfigurationImpl(this.myPathVariables);
    }

    public void applyChanges(JpsPathVariablesConfigurationImpl modified) {
    }

    @Override
    public void addPathVariable(String name, String value) {
        this.myPathVariables.put(name, value);
    }

    @Override
    public void removePathVariable(String name) {
        this.myPathVariables.remove(name);
    }

    @Override
    public String getPathVariable(String name) {
        return this.getUserVariableValue(name);
    }

    @Override
    public String getUserVariableValue(String name) {
        return this.myPathVariables.get(name);
    }

    @Override
    public Map<String, String> getAllVariables() {
        return this.getAllUserVariables();
    }

    @Override
    public Map<String, String> getAllUserVariables() {
        return Collections.unmodifiableMap(this.myPathVariables);
    }
}

