/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.impl;

import java.io.IOException;
import java.util.Map;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.serialization.JpsGlobalElementSaver;
import org.jetbrains.jps.model.serialization.JpsGlobalLoader;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.model.serialization.JpsProjectLoader;
import org.jetbrains.jps.model.serialization.JpsSerializationManager;

public class JpsSerializationManagerImpl
extends JpsSerializationManager {
    @Override
    public JpsModel loadModel(String projectPath, String optionsPath) throws IOException {
        JpsModel model = JpsElementFactory.getInstance().createModel();
        if (optionsPath != null) {
            JpsGlobalLoader.loadGlobalSettings(model.getGlobal(), optionsPath);
        }
        Map<String, String> pathVariables = JpsModelSerializationDataService.computeAllPathVariables(model.getGlobal());
        JpsProjectLoader.loadProject(model.getProject(), pathVariables, projectPath);
        return model;
    }

    @Override
    public void saveGlobalSettings(JpsGlobal global, String optionsPath) throws IOException {
        JpsGlobalElementSaver.saveGlobalElement(global, optionsPath);
    }
}

