/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.Matcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

public class TaskSearchSupport {
    private TaskSearchSupport() {
    }

    public static List<Task> getLocalAndCachedTasks(final TaskManager myManager, String pattern, boolean withClosed) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        ContainerUtil.addAll(tasks, (Iterable)myManager.getLocalTasks(withClosed));
        ContainerUtil.addAll(tasks, (Iterable)ContainerUtil.filter((Collection)myManager.getCachedIssues(withClosed), (Condition)new Condition<Task>(){

            public boolean value(Task task) {
                return myManager.findTask(task.getId()) == null;
            }
        }));
        List<Task> filteredTasks = TaskSearchSupport.filterTasks(pattern, tasks);
        ContainerUtil.sort(filteredTasks, TaskManagerImpl.TASK_UPDATE_COMPARATOR);
        return filteredTasks;
    }

    public static List<Task> filterTasks(String pattern, List<Task> tasks) {
        final Matcher matcher = TaskSearchSupport.getMatcher(pattern);
        return ContainerUtil.mapNotNull(tasks, (Function)new NullableFunction<Task, Task>(){

            public Task fun(Task task) {
                return matcher.matches(task.getId()) || matcher.matches(task.getSummary()) ? task : null;
            }
        });
    }

    public static List<Task> getRepositoriesTasks(TaskManager myManager, String pattern, int offset, int limit, boolean forceRequest, boolean withClosed, ProgressIndicator cancelled) {
        List tasks = myManager.getIssues(pattern, offset, limit, withClosed, cancelled, forceRequest);
        ContainerUtil.sort((List)tasks, TaskManagerImpl.TASK_UPDATE_COMPARATOR);
        return tasks;
    }

    public static List<Task> getItems(TaskManager myManager, String pattern, boolean cached, boolean autopopup) {
        return TaskSearchSupport.filterTasks(pattern, TaskSearchSupport.getTasks(pattern, cached, autopopup, myManager));
    }

    private static Matcher getMatcher(String pattern) {
        StringTokenizer tokenizer = new StringTokenizer(pattern, " ");
        StringBuilder builder = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            builder.append('*');
            builder.append(word);
            builder.append("* ");
        }
        return NameUtil.buildMatcher((String)builder.toString(), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
    }

    private static List<Task> getTasks(String pattern, boolean cached, boolean autopopup, TaskManager myManager) {
        return cached ? myManager.getCachedIssues() : myManager.getIssues(pattern, !autopopup);
    }
}

